/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.apache.solr.util.tracing.GlobalTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TracerConfigurator
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public abstract Tracer getTracer();

    public static void loadTracer(SolrResourceLoader loader, PluginInfo info, ZkStateReader stateReader) {
        if (info == null) {
            if (io.opentracing.util.GlobalTracer.isRegistered()) {
                GlobalTracer.setup(io.opentracing.util.GlobalTracer.get());
                TracerConfigurator.registerListener(stateReader);
            } else {
                GlobalTracer.setup((Tracer)NoopTracerFactory.create());
                GlobalTracer.get().setSamplePercentage(0.0);
            }
        } else {
            TracerConfigurator configurator = loader.newInstance(info.className, TracerConfigurator.class);
            configurator.init(info.initArgs);
            GlobalTracer.setup(configurator.getTracer());
            TracerConfigurator.registerListener(stateReader);
        }
    }

    private static void registerListener(ZkStateReader stateReader) {
        stateReader.registerClusterPropertiesListener(properties -> {
            if (properties.containsKey("samplePercentage")) {
                try {
                    double sampleRate = Double.parseDouble(properties.get("samplePercentage").toString());
                    GlobalTracer.get().setSamplePercentage(sampleRate);
                }
                catch (NumberFormatException e) {
                    log.error("Unable to set sample rate", (Throwable)e);
                }
            } else {
                GlobalTracer.get().setSamplePercentage(0.1);
            }
            return false;
        });
    }
}

