/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.payloads.PayloadDecoder;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.queries.payloads.PayloadScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.PayloadUtils;

public class PayloadScoreQParserPlugin
extends QParserPlugin {
    public static final String NAME = "payload_score";
    public static final String DEFAULT_OPERATOR = "phrase";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                SpanQuery query;
                String field = this.localParams.get("f");
                String value = this.localParams.get("v");
                String func = this.localParams.get("func");
                String operator = this.localParams.get("operator", PayloadScoreQParserPlugin.DEFAULT_OPERATOR);
                if (!operator.equalsIgnoreCase(PayloadScoreQParserPlugin.DEFAULT_OPERATOR) && !operator.equalsIgnoreCase("or")) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Supported operators are : or , phrase");
                }
                boolean includeSpanScore = this.localParams.getBool("includeSpanScore", false);
                if (field == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'f' not specified");
                }
                if (value == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "query string missing");
                }
                FieldType ft = this.req.getCore().getLatestSchema().getFieldType(field);
                Analyzer analyzer = ft.getQueryAnalyzer();
                try {
                    query = PayloadUtils.createSpanQuery(field, value, analyzer, operator);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                if (query == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SpanQuery is null");
                }
                PayloadFunction payloadFunction = PayloadUtils.getPayloadFunction(func);
                if (payloadFunction == null) {
                    throw new SyntaxError("Unknown payload function: " + func);
                }
                PayloadDecoder payloadDecoder = this.req.getCore().getLatestSchema().getPayloadDecoder(field);
                return new PayloadScoreQuery(query, payloadFunction, payloadDecoder, includeSpanScore);
            }
        };
    }
}

