/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;

public class PageTool {
    private long start;
    private int results_per_page = 10;
    private long results_found;
    private int page_count;
    private int current_page_number;

    public PageTool(SolrQueryRequest request, SolrQueryResponse response) {
        Object docs;
        String rows = request.getParams().get("rows");
        if (rows != null) {
            this.results_per_page = Integer.parseInt(rows);
        }
        if ((docs = response.getResponse()) != null) {
            if (docs instanceof DocSlice) {
                this.results_found = ((DocSlice)docs).matches();
                this.start = ((DocSlice)docs).offset();
            } else if (docs instanceof ResultContext) {
                DocList dl = ((ResultContext)docs).getDocList();
                this.results_found = dl.matches();
                this.start = dl.offset();
            } else if (docs instanceof SolrDocumentList) {
                SolrDocumentList doc_list = (SolrDocumentList)docs;
                this.results_found = doc_list.getNumFound();
                this.start = doc_list.getStart();
            } else {
                throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Unknown response type " + docs + ". Expected one of DocSlice, ResultContext or SolrDocumentList");
            }
        }
        this.page_count = (int)Math.ceil((double)this.results_found / (double)this.results_per_page);
        this.current_page_number = (int)Math.ceil((double)this.start / (double)this.results_per_page) + (this.page_count > 0 ? 1 : 0);
    }

    public long getStart() {
        return this.start;
    }

    public int getResults_per_page() {
        return this.results_per_page;
    }

    public long getResults_found() {
        return this.results_found;
    }

    public int getPage_count() {
        return this.page_count;
    }

    public int getCurrent_page_number() {
        return this.current_page_number;
    }

    public String toString() {
        return "Found " + this.results_found + " Page " + this.current_page_number + " of " + this.page_count + " Starting at " + this.start + " per page " + this.results_per_page;
    }
}

