/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class Collect
extends SingleRel {
    protected final String fieldName;

    public Collect(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, String fieldName) {
        super(cluster, traitSet, child);
        this.fieldName = fieldName;
    }

    public Collect(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), Objects.requireNonNull(input.getString("field"), "field"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Collect.sole(inputs));
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new Collect(this.getCluster(), traitSet, input, this.fieldName);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("field", this.fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected RelDataType deriveRowType() {
        return Collect.deriveCollectRowType(this, this.fieldName);
    }

    public static RelDataType deriveCollectRowType(SingleRel rel, String fieldName) {
        RelDataType childType = rel.getInput().getRowType();
        assert (childType.isStruct());
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType ret = SqlTypeUtil.createMultisetType(typeFactory, childType, false);
        ret = typeFactory.builder().add(fieldName, ret).build();
        return typeFactory.createTypeWithNullability(ret, false);
    }
}

