/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Locale;
import org.eclipse.jetty.start.StartLog;

public class FS {
    public static boolean canReadDirectory(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path);
    }

    public static boolean canReadFile(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }

    public static boolean canWrite(Path path) {
        return Files.isWritable(path);
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean createNewFile(Path path) throws IOException {
        Path ret = Files.createFile(path, new FileAttribute[0]);
        return Files.exists(ret, new LinkOption[0]);
    }

    public static boolean ensureDirectoryExists(Path dir) throws IOException {
        if (FS.exists(dir)) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Path is not directory: " + dir.toAbsolutePath());
            }
            return false;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        return true;
    }

    public static void ensureDirectoryWritable(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new IOException("Path does not exist: " + dir.toAbsolutePath());
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Directory does not exist: " + dir.toAbsolutePath());
        }
        if (!Files.isWritable(dir)) {
            throw new IOException("Unable to write to directory: " + dir.toAbsolutePath());
        }
    }

    public static boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean isValidDirectory(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            StartLog.warn("Not a directory: " + path, new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean isXml(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".xml");
    }

    public static String toRelativePath(File baseDir, File path) {
        return baseDir.toURI().relativize(path.toURI()).toASCIIString();
    }

    public static boolean isPropertyFile(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".properties");
    }

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static Path toPath(String path) {
        return FileSystems.getDefault().getPath(FS.separators(path), new String[0]);
    }

    public static void touch(Path path) throws IOException {
        FileTime now = FileTime.fromMillis(System.currentTimeMillis());
        Files.setLastModifiedTime(path, now);
    }

    public static Path toRealPath(Path path) throws IOException {
        return path.toRealPath(new LinkOption[0]);
    }
}

