/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;

public class DocValuesStats {
    private DocValuesStats() {
    }

    public static StatsValues getCounts(SolrIndexSearcher searcher, StatsField statsField, DocSet docs, String[] facet) throws IOException {
        SortedSetDocValues si;
        SchemaField schemaField = statsField.getSchemaField();
        assert (null != statsField.getSchemaField()) : "DocValuesStats requires a StatsField using a SchemaField";
        String fieldName = schemaField.getName();
        FieldType ft = schemaField.getType();
        StatsValues res = StatsValuesFactory.createStatsValues(statsField);
        FieldFacetStats[] facetStats = new FieldFacetStats[facet.length];
        int upto = 0;
        for (String facetField : facet) {
            SchemaField fsf = searcher.getSchema().getField(facetField);
            if (fsf.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats can only facet on single-valued fields, not: " + facetField);
            }
            SchemaField facetSchemaField = searcher.getSchema().getField(facetField);
            facetStats[upto++] = new FieldFacetStats(searcher, facetSchemaField, statsField);
        }
        boolean multiValued = schemaField.multiValued() || ft.multiValuedFieldCache();
        OrdinalMap ordinalMap = null;
        if (multiValued) {
            si = searcher.getSlowAtomicReader().getSortedSetDocValues(fieldName);
            if (si instanceof MultiDocValues.MultiSortedSetDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)si).mapping;
            }
        } else {
            SortedDocValues single = searcher.getSlowAtomicReader().getSortedDocValues(fieldName);
            SortedSetDocValues sortedSetDocValues = si = single == null ? null : DocValues.singleton((SortedDocValues)single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
        if (si == null) {
            si = DocValues.emptySortedSet();
        }
        if (si.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Currently this stats method is limited to 2147483647 unique terms");
        }
        int missingDocCountTotal = 0;
        int nTerms = (int)si.getValueCount();
        int[] counts = new int[nTerms];
        Filter filter = docs.getTopFilter();
        List leaves = searcher.getTopReaderContext().leaves();
        for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
            SortedSetDocValues sub;
            LeafReaderContext leaf = (LeafReaderContext)leaves.get(subIndex);
            DocIdSet dis = filter.getDocIdSet(leaf, null);
            FieldFacetStats[] disi = null;
            if (dis != null) {
                disi = dis.iterator();
            }
            if (disi == null) continue;
            int docBase = leaf.docBase;
            if (multiValued) {
                SortedDocValues singleton;
                sub = leaf.reader().getSortedSetDocValues(fieldName);
                if (sub == null) {
                    sub = DocValues.emptySortedSet();
                }
                if ((singleton = DocValues.unwrapSingleton((SortedSetDocValues)sub)) != null) {
                    missingDocCountTotal += DocValuesStats.accumSingle(counts, docBase, facetStats, singleton, (DocIdSetIterator)disi, subIndex, ordinalMap);
                    continue;
                }
                missingDocCountTotal += DocValuesStats.accumMulti(counts, docBase, facetStats, sub, (DocIdSetIterator)disi, subIndex, ordinalMap);
                continue;
            }
            sub = leaf.reader().getSortedDocValues(fieldName);
            if (sub == null) {
                sub = DocValues.emptySorted();
            }
            missingDocCountTotal += DocValuesStats.accumSingle(counts, docBase, facetStats, (SortedDocValues)sub, (DocIdSetIterator)disi, subIndex, ordinalMap);
        }
        for (int ord = 0; ord < counts.length; ++ord) {
            int count = counts[ord];
            if (count <= 0) continue;
            BytesRef value = si.lookupOrd((long)ord);
            res.accumulate(value, count);
            for (FieldFacetStats f : facetStats) {
                f.accumulateTermNum(ord, value);
            }
        }
        res.addMissing(missingDocCountTotal);
        if (facetStats.length > 0) {
            for (FieldFacetStats f : facetStats) {
                Map<String, StatsValues> facetStatsValues = f.facetStatsValues;
                f.accumulateMissing();
                res.addFacet(f.name, facetStatsValues);
            }
        }
        return res;
    }

    static int accumSingle(int[] counts, int docBase, FieldFacetStats[] facetStats, SortedDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        LongValues ordMap = map == null ? null : map.getGlobalOrds(subIndex);
        int missingDocCount = 0;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (doc > si.docID()) {
                si.advance(doc);
            }
            if (doc == si.docID()) {
                int term = si.ordValue();
                if (map != null) {
                    term = (int)ordMap.get((long)term);
                }
                int n = term;
                counts[n] = counts[n] + 1;
                FieldFacetStats[] fieldFacetStatsArray = facetStats;
                int n2 = fieldFacetStatsArray.length;
                for (int i = 0; i < n2; ++i) {
                    FieldFacetStats f = fieldFacetStatsArray[i];
                    f.facetTermNum(docBase + doc, term);
                }
                continue;
            }
            for (FieldFacetStats f : facetStats) {
                f.facetMissingNum(docBase + doc);
            }
            ++missingDocCount;
        }
        return missingDocCount;
    }

    static int accumMulti(int[] counts, int docBase, FieldFacetStats[] facetStats, SortedSetDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        LongValues ordMap = map == null ? null : map.getGlobalOrds(subIndex);
        int missingDocCount = 0;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (doc > si.docID()) {
                si.advance(doc);
            }
            if (doc == si.docID()) {
                long ord;
                while ((ord = si.nextOrd()) != -1L) {
                    int term = (int)ord;
                    if (map != null) {
                        term = (int)ordMap.get((long)term);
                    }
                    int n = term;
                    counts[n] = counts[n] + 1;
                    for (FieldFacetStats f : facetStats) {
                        f.facetTermNum(docBase + doc, term);
                    }
                }
                continue;
            }
            for (FieldFacetStats f : facetStats) {
                f.facetMissingNum(docBase + doc);
            }
            ++missingDocCount;
        }
        return missingDocCount;
    }
}

