/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class UnaryComparisonOperatorNode
extends UnaryOperatorNode {
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.bindOperand(fromList, subqueryList, vector);
        this.bindComparisonOperator();
        return this;
    }

    public void bindComparisonOperator() throws StandardException {
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.getNegation(this.operand);
    }

    abstract UnaryOperatorNode getNegation(ValueNode var1) throws StandardException;

    public ColumnReference getColumnOperand(Optimizable optimizable, int n) {
        ColumnReference columnReference;
        FromBaseTable fromBaseTable = (FromBaseTable)optimizable;
        if (this.operand instanceof ColumnReference && (columnReference = (ColumnReference)this.operand).getTableNumber() == fromBaseTable.getTableNumber() && columnReference.getSource().getColumnPosition() == n) {
            return columnReference;
        }
        return null;
    }

    public ColumnReference getColumnOperand(Optimizable optimizable) {
        ColumnReference columnReference;
        if (this.operand instanceof ColumnReference && (columnReference = (ColumnReference)this.operand).getTableNumber() == optimizable.getTableNumber()) {
            return columnReference;
        }
        return null;
    }

    public ValueNode getOperand(ColumnReference columnReference, int n, boolean bl) {
        if (bl) {
            return null;
        }
        if (this.operand instanceof ColumnReference) {
            JBitSet jBitSet = new JBitSet(n);
            JBitSet jBitSet2 = new JBitSet(n);
            BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet2);
            ColumnReference columnReference2 = (ColumnReference)this.operand;
            try {
                columnReference2.accept(baseTableNumbersVisitor);
                baseTableNumbersVisitor.setTableMap(jBitSet);
                columnReference.accept(baseTableNumbersVisitor);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            jBitSet2.and(jBitSet);
            if (jBitSet2.getFirstSetBit() != -1 && columnReference2.getSource().getColumnPosition() == columnReference.getColumnNumber()) {
                return this.operand;
            }
        }
        return null;
    }

    public boolean selfComparison(ColumnReference columnReference) {
        return false;
    }

    public ValueNode getExpressionOperand(int n, int n2, FromTable fromTable) {
        return null;
    }

    public void generateExpressionOperand(Optimizable optimizable, int n, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.generateNull(methodBuilder, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
    }

    public int getStartOperator(Optimizable optimizable) {
        return 1;
    }

    public int getStopOperator(Optimizable optimizable) {
        return -1;
    }

    public void generateOrderedNulls(MethodBuilder methodBuilder) {
        methodBuilder.push(true);
    }

    public void generateQualMethod(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        expressionClassBuilder.generateNull(methodBuilder2, this.operand.getTypeCompiler(), this.operand.getTypeServices().getCollationType());
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    public void generateAbsoluteColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n = this.getAbsoluteColumnPosition(optimizable);
        methodBuilder.push(n);
    }

    public void generateRelativeColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n = this.getAbsoluteColumnPosition(optimizable);
        n = optimizable.convertAbsoluteToRelativeColumnPosition(n);
        methodBuilder.push(n);
    }

    private int getAbsoluteColumnPosition(Optimizable optimizable) {
        ColumnReference columnReference = (ColumnReference)this.operand;
        int n = columnReference.getSource().getColumnPosition();
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (conglomerateDescriptor.isIndex()) {
            n = conglomerateDescriptor.getIndexDescriptor().getKeyColumnPosition(n);
        }
        return n - 1;
    }

    public boolean orderedNulls() {
        return true;
    }

    public boolean isQualifier(Optimizable optimizable, boolean bl) {
        if (!(this.operand instanceof ColumnReference)) {
            return false;
        }
        ColumnReference columnReference = (ColumnReference)this.operand;
        FromTable fromTable = (FromTable)optimizable;
        return columnReference.getTableNumber() == fromTable.getTableNumber();
    }

    public int getOrderableVariantType(Optimizable optimizable) throws StandardException {
        return this.operand.getOrderableVariantType();
    }
}

