/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.LongConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.common.SolrException;

class DateStreamReplaceFunction
extends DateValueStream.AbstractDateValueStream {
    private final DateValueStream baseExpr;
    private final DateValue compExpr;
    private final DateValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public DateStreamReplaceFunction(DateValueStream baseExpr, DateValue compExpr, DateValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        long compValue = this.compExpr.getLong();
        if (this.compExpr.exists()) {
            long fillValue = this.fillExpr.getLong();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamLongs(value -> {
                if (value == compValue) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamLongs(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

