/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.DoubleCheckedReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;

public class SumCollector
extends ReductionDataCollector<SumData> {
    private final DoubleValueStream param;
    public static final String name = "sum";
    private final String exprStr;
    private double sum;
    private boolean exists;
    double tempSum;
    boolean tempExists;

    public SumCollector(DoubleValueStream param) {
        this.param = param;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    public double sum() {
        return this.sum;
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public SumData newData() {
        SumData data = new SumData();
        data.sum = 0.0;
        data.exists = false;
        return data;
    }

    @Override
    public void collect() {
        this.tempSum = 0.0;
        this.tempExists = false;
        this.param.streamDoubles(val -> {
            this.tempSum += val;
            this.tempExists = true;
        });
    }

    @Override
    protected void apply(SumData data) {
        data.sum += this.tempSum;
        data.exists |= this.tempExists;
    }

    @Override
    public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
        consumer.accept(new DoubleCheckedReservation(value -> {
            ((SumData)this.ioData).sum += value;
            ((SumData)this.ioData).exists = true;
        }, () -> ((SumData)this.ioData).sum, () -> ((SumData)this.ioData).exists));
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.sum = ((SumData)data).sum;
        this.exists = data.exists;
    }

    @Override
    public void setData(ReductionData data) {
        this.sum = ((SumData)data).sum;
        this.exists = data.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class SumData
    extends ReductionData {
        double sum;
    }
}

