/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.memory;

import java.io.IOException;
import java.util.Iterator;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;

public class MemoryProtocolHandler
implements ProtocolHandler {
    protected Adapter adapter = null;
    private int nameIndex = 0;

    public void setAttribute(String name, Object value) {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Iterator getAttributeNames() {
        return null;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public synchronized int getNameIndex() {
        if (this.nameIndex == 0) {
            this.nameIndex = AbstractProtocol.nextNameIndex();
        }
        return this.nameIndex;
    }

    public int getLocalPort() {
        return -1;
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void pause() throws Exception {
    }

    public void resume() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public void process(Request request, ByteChunk input, Response response, ByteChunk output) throws Exception {
        ByteChunkInputBuffer inputBuffer = new ByteChunkInputBuffer(input);
        ByteChunkOutputBuffer outputBuffer = new ByteChunkOutputBuffer(output);
        request.setInputBuffer(inputBuffer);
        response.setOutputBuffer(outputBuffer);
        this.adapter.service(request, response);
    }

    protected class ByteChunkOutputBuffer
    implements OutputBuffer {
        protected ByteChunk output = null;

        public ByteChunkOutputBuffer(ByteChunk output) {
            this.output = output;
        }

        public int doWrite(ByteChunk chunk, Response response) throws IOException {
            this.output.append(chunk);
            return chunk.getLength();
        }
    }

    protected class ByteChunkInputBuffer
    implements InputBuffer {
        protected ByteChunk input = null;

        public ByteChunkInputBuffer(ByteChunk input) {
            this.input = input;
        }

        public int doRead(ByteChunk chunk, Request request) throws IOException {
            return this.input.substract(chunk);
        }
    }
}

