/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.util.res.StringManager;

public class HttpMessages {
    private static final Map<Locale, HttpMessages> instances = new ConcurrentHashMap<Locale, HttpMessages>();
    private static final HttpMessages DEFAULT = new HttpMessages(StringManager.getManager((String)"org.apache.tomcat.util.http.res", (Locale)Locale.getDefault()));
    private final StringManager sm;
    private String st_200 = null;
    private String st_302 = null;
    private String st_400 = null;
    private String st_404 = null;
    private String st_500 = null;

    private HttpMessages(StringManager sm) {
        this.sm = sm;
    }

    public String getMessage(int status) {
        switch (status) {
            case 200: {
                if (this.st_200 == null) {
                    this.st_200 = this.sm.getString("sc.200");
                }
                return this.st_200;
            }
            case 302: {
                if (this.st_302 == null) {
                    this.st_302 = this.sm.getString("sc.302");
                }
                return this.st_302;
            }
            case 400: {
                if (this.st_400 == null) {
                    this.st_400 = this.sm.getString("sc.400");
                }
                return this.st_400;
            }
            case 404: {
                if (this.st_404 == null) {
                    this.st_404 = this.sm.getString("sc.404");
                }
                return this.st_404;
            }
            case 500: {
                if (this.st_500 == null) {
                    this.st_500 = this.sm.getString("sc.500");
                }
                return this.st_500;
            }
        }
        return this.sm.getString("sc." + status);
    }

    public static HttpMessages getInstance(Locale locale) {
        HttpMessages result = instances.get(locale);
        if (result == null) {
            StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http.res", (Locale)locale);
            result = Locale.getDefault().equals(sm.getLocale()) ? DEFAULT : new HttpMessages(sm);
            instances.put(locale, result);
        }
        return result;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static boolean isSafeInHttpHeader(String msg) {
        if (msg == null) {
            return true;
        }
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (' ' <= c && c <= '~' || '\u0080' <= c && c <= '\u00ff' || c == '\t') continue;
            return false;
        }
        return true;
    }
}

