/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.SampleIds;
import java.util.Arrays;

public final class Samples {
    private static final SampleIds sampleIds = SampleIds.instance();
    private final int[] idIndices;
    private final boolean[] isDiploid;

    public Samples(int[] nArray, boolean[] blArray) {
        if (nArray.length != blArray.length) {
            throw new IllegalArgumentException(String.valueOf(blArray));
        }
        Samples.checkForDuplicates(nArray);
        this.idIndices = (int[])nArray.clone();
        this.isDiploid = (boolean[])blArray.clone();
    }

    private static void checkForDuplicates(int[] nArray) {
        int n;
        int[] nArray2 = Arrays.stream(nArray).parallel().sorted().toArray();
        if (nArray2[0] < 0) {
            throw new IllegalArgumentException(String.valueOf(nArray2[0]));
        }
        for (n = 1; n < nArray2.length; ++n) {
            if (nArray2[n - 1] != nArray2[n]) continue;
            throw new IllegalArgumentException(String.valueOf(nArray2[n]));
        }
        n = nArray.length - 1;
        if (nArray2[n] >= sampleIds.size()) {
            throw new IllegalArgumentException(String.valueOf(nArray2[n]));
        }
    }

    public static Samples combine(Samples samples, Samples samples2) {
        int n = samples.size();
        int n2 = samples2.size();
        int n3 = n + n2;
        int[] nArray = new int[n3];
        boolean[] blArray = new boolean[n3];
        System.arraycopy(samples.idIndices, 0, nArray, 0, n);
        System.arraycopy(samples2.idIndices, 0, nArray, n, n2);
        System.arraycopy(samples.isDiploid, 0, blArray, 0, n);
        System.arraycopy(samples2.isDiploid, 0, blArray, n, n2);
        return new Samples(nArray, blArray);
    }

    public int[] idIndexToIndex() {
        int[] nArray = new int[sampleIds.size()];
        Arrays.fill(nArray, -1);
        int n = 0;
        while (n < this.idIndices.length) {
            int n2 = this.idIndices[n];
            assert (nArray[n2] == -1);
            nArray[n2] = n++;
        }
        return nArray;
    }

    public static Samples fromIds(String[] stringArray, boolean[] blArray) {
        return new Samples(sampleIds.getIndices(stringArray), blArray);
    }

    public int hashCode() {
        int n = 59;
        n += 31 * Arrays.hashCode(this.isDiploid);
        return n += 31 * Arrays.hashCode(this.idIndices);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Samples samples = (Samples)object;
        if (!Arrays.equals(this.isDiploid, samples.isDiploid)) {
            return false;
        }
        return Arrays.equals(this.idIndices, samples.idIndices);
    }

    public int idIndex(int n) {
        return this.idIndices[n];
    }

    public int size() {
        return this.idIndices.length;
    }

    public String id(int n) {
        return sampleIds.id(this.idIndices[n]);
    }

    public String[] ids() {
        return sampleIds.ids(this.idIndices);
    }

    public boolean isDiploid(int n) {
        return this.isDiploid[n];
    }

    public String toString() {
        return Arrays.toString(this.ids());
    }
}

