/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import java.io.Serializable;

public final class SequenceId
implements Serializable {
    private static final long serialVersionUID = 2181572437818064822L;
    private final long id;
    private final boolean isFwd;
    private final String strId;
    public static boolean STORE_FULL_ID = false;

    public SequenceId(long id) {
        this(id, true);
    }

    public SequenceId(long id, boolean isFwd) {
        this.id = id;
        this.isFwd = isFwd;
        this.strId = null;
    }

    public SequenceId(long id, boolean isFwd, String strId) {
        this.id = id;
        this.isFwd = isFwd;
        this.strId = strId;
    }

    public SequenceId createOffset(long offset) {
        return new SequenceId(this.id + offset, this.isFwd, this.strId);
    }

    public SequenceId complimentId() {
        return new SequenceId(this.id, !this.isFwd, this.strId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceId other = (SequenceId)obj;
        return this.id == other.id && this.isFwd == other.isFwd;
    }

    public boolean isForward() {
        return this.isFwd;
    }

    public long getHeaderId() {
        return this.id;
    }

    public String getHeader() {
        if (this.strId != null) {
            return this.strId;
        }
        return String.valueOf(this.id);
    }

    public int hashCode() {
        return this.isFwd ? (int)this.id : -((int)this.id);
    }

    public String toString() {
        return "" + this.getHeader() + (this.isFwd ? "(fwd)" : "(rev)");
    }

    public String toStringInt() {
        return "" + this.getHeader() + (this.isFwd ? " 1" : " 0");
    }
}

