/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.igoweb.games.Clock;
import org.igoweb.go.Game;
import org.igoweb.go.swing.PlayerWidget;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.PicPopup;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ImageViewer;

public class KPlayerWidget
extends PlayerWidget
implements EventListener {
    private ImageViewer avatar;

    public KPlayerWidget(int color, Game game, Clock clock, String name, int rank) {
        super(color, game, clock, name, rank);
        this.setLayout(new PlayerBoxLayout());
    }

    public void setImage(User who, GuiClientUtil util) {
        this.avatar = new ImageViewer(null);
        this.avatar.setToolTipText(Defs.getString(-903340544));
        new PicPopup(who.name, this.avatar);
        this.add(this.avatar);
        util.getUserPic(who, this.getToolkit(), this);
    }

    @Override
    protected JComponent getMainPanel() {
        if (this.getComponentCount() == 0) {
            this.add(new JPanel());
        }
        return (JComponent)this.getComponent(0);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 65536 && this.avatar != null) {
            this.avatar.setImage((Image)event.arg);
        }
    }

    private static class PlayerBoxLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int h = size.height - (insets.top + insets.bottom);
            int w = size.width - (insets.left + insets.right);
            if (parent.getComponentCount() == 1) {
                parent.getComponent(0).setBounds(insets.left, insets.top, w, h);
            } else {
                int picW = (h * 141 + 100) / 200;
                parent.getComponent(0).setBounds(insets.left, insets.top, w - (picW + 2), h);
                parent.getComponent(1).setBounds(size.width - (insets.right + picW), insets.top, picW, h);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getComponent(0).getMinimumSize();
            Dimension result = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
            if (parent.getComponentCount() == 2) {
                result.width += 2 + (size.height * 141 + 100) / 200;
            }
            return result;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getComponent(0).getPreferredSize();
            Dimension result = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
            if (parent.getComponentCount() == 2) {
                result.width += 2 + (size.height * 141 + 100) / 200;
            }
            return result;
        }
    }
}

