
dnl AC_PATH_COCONUT([WITH_GTK])
dnl
dnl Test for coconut, and define COCONUT_CFLAGS and COCONUT_LIBS
dnl

AC_DEFUN(AC_PATH_COCONUT,[
dnl
dnl  Get the cflags and libraries from the coconut-config script
dnl

coconut_config_args="" ;
no_coconut="" ;
COCONUT_CFLAGS="" ;
COCONUT_LIBS="" ;

dnl  (1) define the configure option to get the prefix of coconut library
AC_ARG_WITH(coconut-prefix, [  --with-coconut-prefix=PFX    prefix where coconut library is installed (optional)],
  coconut_config_prefix="$withval", coconut_config_prefix="")

dnl  (2) define the configure option to get the exec prefix of coconut library
AC_ARG_WITH(coconut-exec-prefix, [  --with-coconut-exec-prefix=PFX   exec prefix where coconut library is installed (optional)],
  coconut_config_exec_prefix="$withval", coconut_config_exec_prefix="")

dnl  (3) check the coconut_config_exec_prefix was set or not
if test "X${coconut_config_exec_prefix}" != "X" ; then
	coconut_config_args="--exec-prefix=$coconut_config_exec_prefix" ;
fi

dnl  (4) check the coconut_config_prefix was set or not
if test "X${coconut_config_prefix}" != "X" ; then
	coconut_config_args="$coconut_config_args --prefix=$coconut_config_prefix" ;
fi

dnl  (5) check the existence of coconut-config
AC_PATH_PROG(COCONUT_CONFIG, coconut-config, no)

dnl  (6) check WITH_GTK flag
if test "x$1" = "xwith-gtk" ; then
	coconut_config_with_gtk="--with-gtk"
else
	coconut_config_with_gtk=""
fi

dnl  (6) make CFLAGS ans LIBS
AC_MSG_CHECKING(cflags of coconut library)
if test "$COCONUT_CONFIG" = "no" ; then
	AC_MSG_RESULT([not found])
else
	COCONUT_CFLAGS=`$COCONUT_CONFIG $coconut_config_args --cflags $coconut_config_with_gtk` 
	AC_MSG_RESULT($COCONUT_CFLAGS)
fi
AC_MSG_CHECKING(libs of coconut library)
if test "$COCONUT_CONFIG" = "no" ; then
	AC_MSG_RESULT([not found])
else
	COCONUT_LIBS=`$COCONUT_CONFIG $coconut_config_args --libs $coconut_config_with_gtk`
	AC_MSG_RESULT($COCONUT_LIBS)
fi
AC_SUBST(COCONUT_CFLAGS)
AC_SUBST(COCONUT_LIBS)
])

