### Copyright (C) 1995-2000 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

set __hash "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#"
if {[info commands DEBUG] == ""} {
  proc DEBUG {args} {}
}
############################################################
# First of all check for the right version of wish
############################################################
if {[info exists tk_version] && [string index $tk_version 0] <  4} {
  puts {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    WARNING
    
    The Dotfile Generator requires at least Tcl 7.4 / Tk4.0}
  puts "    Your version of Tk is $tk_version"
  puts {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
}
if {[info exists tk_version]} {
  wm title . "Dotfile Generator"
  wm withdraw .
}



############################################################
#             Ask for a module and a language
############################################################
source [lindex $argv 0]/system.tcl
source [lindex $argv 0]/language.tcl
set libPath [lindex $argv 1]
if {[llength $argv] != 2} {
  if {![regexp "(.*)/(.*)" [lindex $argv 2] all __modLang __modName]} {
    set __modName [lindex $argv 2]
    if {[file exists $libPath/$__system(language)/$__modName]} {
      set __modLang $__system(language)
    } else {
      set __modLang english
    }
  }
} else {
  set __modName ""
  askForInfo
}
set verfile $libPath/$__modLang/$__modName/version
if {[file exists $verfile]} {
  set FILE [open $verfile]
  set module(version) [gets $FILE]
  close $FILE
} else {
  set module(version) ""
}
loadLanguageInfo
unset verfile
set argv [concat [list [lindex $argv 0] $libPath/$__modLang/$__modName] [lrange $argv 3 end]]



############################################################
#                     Sourceing function files
############################################################
foreach __file {parse types menus help functions util save
  bytecompile setup generate fillouts edit dialog color combo
  import export setPages details load browser mail} {
  source [lindex $argv 0]/$__file.tcl
}

############################################################
#                   sourcing the module
############################################################
proc import {file} {
  global argv __files
  source [lindex $argv 1]/$file
  lappend __files $file
}

############################################################
#           and now for the copyright notice
############################################################
if {[lindex $argv 2] != "bytecompile"} {
  puts "The Dotfile Generator version 2.4.1 Copyright (C) 1995-2000 Jesper K. Pedersen"
  puts "The Dotfile Generator comes with ABSOLUTELY NO WARRANTY; for details"
  puts "see the \"Help\" menu. This is free software, and you are welcome to"
  puts "redistribute it under certain conditions; see the \"Help\" menu"
  puts "for details."

  # load the locale command(s) if it exist
  loadlocalCommand
}

set __changed 0
set __fillOutCounter 0    ;# just to avoid testing existens
set __editInfo(trace) 0
set __editInfo(menuload) 0
set __clipboardName ""    ;# just to avoid testing existens
set __editInfo(version) "2.4.1"
set __editInfo(releaseDate) "Sat Feb 19 2000"
set __editInfo(name) ""   ;# just to avoid testing existens
set __busy {}
set __editInfo(loadFile) ""
set __clean(dummy) 1
set __widgetArgs(scrollbar) scrollbar
set __BASEDIR [file dirname [lindex $argv 0]]
set __BITMAPDIR [lindex $argv 0]/bitmaps
set loadingExports 0
############################################################
#   loading the modules or the byte compile file
############################################################
set __bc [byteCompile?]

if {$__bc == "loadedBCFile"} {
  set loadedByteCompileFile 1
} else {
  set loadedByteCompileFile 0
}
source [lindex $argv 1]/main.template
parseFile
if {$__bc != "loadedBCFile"} {
  loadFiles
}

if {[file exists [lindex $argv 1]/local.template] && !$loadedByteCompileFile} {
  import local.template
}
if {$__bc == "doByteCompile"} {
  byteCompileFile
}
if {$__bc == "loadedBCFile"} {
  testBCVersion
}
############################################################
#                    General initializion
############################################################
if {![info exists setup(dotfile)]} {
  set setup(dotfile) {{file1 Dotfile output.dot "\#"}}
}
foreach elm $setup(dotfile) {
  if {![regexp {^[a-z0-9]+$} [lindex $elm 0]]} {
    error "File handle \"[lindex $elm 0]\" is illegal, it may only contain letters and numbers"
  }
}
foreach __elm $setup(dotfile) {
  set __fileHandles([lindex $__elm 0]) [lindex $__elm 2]
}
if {![info exists setup(file)]} {
  set setup(file) 1
}
if {![info exists setup(print)]} {
  set setup(print) 1
}
if {![info exists setup(whatToGenerate)]} {
  set setup(whatToGenerate) all
}
if {![info exists setup(generateDefault)]} {
  set setup(generateDefault) 0
}
if {![info exists setup(placeWindows)]} {
  set setup(placeWindows) 1
}
if {![info exists setup(preventBytecompile)]} {
  set setup(preventBytecompile) 0
}
if {![info exists setup(saveOnGenerate)]} {
  set setup(saveOnGenerate) 0
}
if {![info exists module(overAllDesc)]} {
  set module(overAllDesc) [langExp "%d" "\[exec date\]" [langExp "%s" $module(name) $__language(dotfile,4)]]
}
set __pathProgsNames(pre_generate) "/Pre commands"
set __pathProgsNames(post_generate) "/Post commands"
############################################################
#                loading the save file
############################################################
wm withdraw .

if {[lindex $argv 2] == "convertExports"} {
  ### initialize all the pages to a default value
  foreach page $__progList {
    setBasic $page
  }
  set __loadOverWrite $__progList
  import-file [lindex $argv 3]
  createDir [file dirname [lindex $argv 4]]

  saveFile  [lindex $argv 4]
  exit
} else {
  initialize_and_load
}
############################################################
# linking all variable globaly as func@var
############################################################
foreach __function $__progList {
  set __editInfo(name) $__function
  linkVars $__function __$__function top $__function
}
set __editInfo(name) ""   ;# just to avoid testing existens

############################################################
#                      Menu WINDOW
############################################################
createMenu


############################################################
#               global bindings for entry's
############################################################
bind Entry <Double-ButtonPress-3> {%W delete sel.first sel.last}
bind . <Control-s> generate
if {$setup(placeWindows)} {
  wm geometry . +0+0
}
wm deiconify .
