/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;

public final class RecruitPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(RecruitPanel.class.getName());
    private final JButton[] person = new JButton[this.getMyPlayer().getEurope().getRecruitables().size()];
    private boolean shouldEnable = false;

    public RecruitPanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout("wrap 1", "", ""));
        for (int i = 0; i < this.person.length; ++i) {
            this.person[i] = new JButton();
            this.person[i].setActionCommand(String.valueOf(i));
            this.person[i].addActionListener(this);
            this.person[i].setIconTextGap(3);
        }
        this.update();
    }

    public void update() {
        this.removeAll();
        Player player = this.getMyPlayer();
        Europe europe = player.getEurope();
        int production = player.getTotalImmigrationProduction();
        int turns = 100;
        if (production > 0) {
            int immigrationRequired = player.getImmigrationRequired() - player.getImmigration();
            turns = immigrationRequired / production;
            if (immigrationRequired % production > 0) {
                ++turns;
            }
        }
        int recruitPrice = player.getRecruitPrice();
        this.add((Component)Utility.localizedTextArea(StringTemplate.template("recruitPanel.clickOn").addAmount("%money%", recruitPrice).addAmount("%number%", turns)), "wrap 20");
        this.shouldEnable = false;
        int i = 0;
        for (UnitType ut : europe.getRecruitables()) {
            boolean enable = player.checkGold(recruitPrice);
            this.person[i].setText(Messages.getName(ut));
            this.person[i].setIcon(new ImageIcon(this.getImageLibrary().getSmallUnitImage(ut)));
            this.person[i].setEnabled(enable);
            this.add((Component)this.person[i], "growx");
            this.shouldEnable |= enable;
            ++i;
        }
        this.okButton.setText(Messages.message("close"));
        this.add((Component)this.okButton, "newline 20, tag ok");
        this.setSize(this.getPreferredSize());
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(ae);
        } else {
            try {
                int index = Integer.parseInt(command);
                if (Europe.MigrationType.validMigrantIndex(index)) {
                    this.igc().recruitUnitInEurope(index);
                    this.getGUI().updateEuropeanSubpanels();
                    if (!this.shouldEnable) {
                        this.getGUI().removeFromCanvas(this);
                    }
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            logger.warning("Invalid action command: " + command);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        if (this.person != null) {
            for (int i = 0; i < this.person.length; ++i) {
                this.person[i] = null;
            }
        }
    }
}

