/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Occupation;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;

public abstract class WorkLocation
extends UnitLocation
implements Ownable {
    private static final Logger logger = Logger.getLogger(WorkLocation.class.getName());
    public static final List<AbstractGoods> EMPTY_LIST = Collections.emptyList();
    protected Colony colony;
    private ProductionType productionType;
    private static final String COLONY_TAG = "colony";

    protected WorkLocation(Game game) {
        super(game);
    }

    public WorkLocation(Game game, String id) {
        super(game, id);
    }

    public Settlement getOwningSettlement() {
        return this.colony;
    }

    public final ProductionType getProductionType() {
        return this.productionType;
    }

    public final void setProductionType(ProductionType newProductionType) {
        if (!Utils.equals(newProductionType, this.productionType)) {
            this.productionType = newProductionType;
            this.colony.invalidateCache();
            logger.fine("Production type at " + this + " is now: " + newProductionType);
        }
    }

    public GoodsType getCurrentWorkType() {
        Unit unit = this.getFirstUnit();
        return unit != null && unit.getType() != null ? unit.getWorkType() : null;
    }

    public void updateProductionType() {
        this.setProductionType(this.getBestProductionType(this.isEmpty(), this.getCurrentWorkType()));
    }

    public ProductionType getBestProductionType(boolean unattended, GoodsType workType) {
        ProductionType best = null;
        int amount = -1;
        for (ProductionType pt : this.getAvailableProductionTypes(unattended)) {
            for (AbstractGoods output : pt.getOutputs()) {
                if (workType != null && workType != output.getType() || amount >= output.getAmount()) continue;
                amount = output.getAmount();
                best = pt;
            }
        }
        return best;
    }

    public Occupation getOccupation(Unit unit, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.colony.getOccupationTrace() ? 64 : 0);
        lb.add(this.colony.getName(), "/", this, ".getOccupation(", unit, ")");
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (Collection<GoodsType> types : this.colony.getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            WorkLocation.logFreeColObjects(types, lb);
            bestAmount = best.improve(unit, this, bestAmount, types, lb);
            if (best.workType == null) continue;
            lb.add("\n  => ", best);
            break;
        }
        if (best.workType == null) {
            lb.add("\n  FAILED");
        }
        lb.log(logger, Level.WARNING);
        return best.workType == null ? null : best;
    }

    public Occupation getOccupation(UnitType unitType) {
        Specification spec = this.getSpecification();
        if (unitType == null) {
            unitType = spec.getDefaultUnitType(this.getOwner().getNationType());
        }
        LogBuilder lb = new LogBuilder(this.colony.getOccupationTrace() ? 64 : 0);
        lb.add(this.colony.getName(), "/", this, ".getOccupation(", unitType.getSuffix(), ")");
        List<GoodsType> types = spec.getGoodsTypeList();
        Occupation best = new Occupation(null, null, null);
        lb.add("\n  ");
        WorkLocation.logFreeColObjects(types, lb);
        int bestAmount = best.improve(unitType, this, 0, types, lb);
        if (best.workType != null) {
            lb.add("\n  => ", best);
        } else {
            lb.add("\n  FAILED");
        }
        lb.log(logger, Level.WARNING);
        return best.workType == null ? null : best;
    }

    public GoodsType getWorkFor(Unit unit) {
        Occupation occupation = this.getOccupation(unit, true);
        return occupation == null ? null : occupation.workType;
    }

    public boolean setWorkFor(Unit unit) {
        Occupation occupation = this.getOccupation(unit, false);
        return occupation != null && occupation.install(unit);
    }

    private Suggestion getSuggestion(Unit unit, ProductionType productionType, GoodsType goodsType) {
        Building bu;
        UnitType better;
        if ((unit == null || !this.contains(unit)) && this.isFull() || productionType == null || goodsType == null) {
            return null;
        }
        Specification spec = this.getSpecification();
        Player owner = this.getOwner();
        UnitType expert = spec.getExpertForProducing(goodsType);
        UnitType unitType = better = expert != null ? expert : spec.getDefaultUnitType(owner);
        if (unit != null && better == unit.getType()) {
            return null;
        }
        int delta = this.getPotentialProduction(goodsType, better);
        if (unit != null) {
            delta -= this.getPotentialProduction(goodsType, unit.getType());
        }
        for (AbstractGoods in : productionType.getInputs()) {
            delta = Math.min(delta, this.colony.getNetProductionOf(in.getType()));
        }
        if (delta <= 0) {
            return null;
        }
        if (owner.getPlayerType() == Player.PlayerType.INDEPENDENT && (goodsType.isLibertyType() && this.colony.getSoL() >= 100 || goodsType.isImmigrationType())) {
            return null;
        }
        boolean ok = false;
        if (this instanceof ColonyTile) {
            Tile tile = ((ColonyTile)this).getWorkTile();
            ok = owner.owns(tile) || owner.canClaimForSettlement(tile);
        } else if (this instanceof Building && (bu = (Building)this).canAddType(better)) {
            BuildableType bt;
            Colony colony = this.getColony();
            if (bu.getLevel() > 1 || unit != null) {
                ok = true;
            } else if (colony.getTotalProductionOf(goodsType) == 0 && (bt = colony.getCurrentlyBuilding()) != null && AbstractGoods.containsType(goodsType, bt.getRequiredGoods())) {
                ok = true;
            }
        }
        return !ok ? null : new Suggestion(this, unit == null ? null : unit.getType(), better, goodsType, delta);
    }

    public Map<Unit, Suggestion> getSuggestions() {
        Suggestion sug;
        GoodsType work;
        HashMap<Unit, Suggestion> result = new HashMap<Unit, Suggestion>();
        if (!this.canBeWorked() || this.canTeach()) {
            return result;
        }
        Occupation occ = this.getOccupation(null);
        for (Unit u : this.getUnitList()) {
            if (u.getTeacher() != null) continue;
            work = u.getWorkType();
            if (work == null && occ != null) {
                work = occ.workType;
            }
            if ((sug = this.getSuggestion(u, this.getProductionType(), work)) == null) continue;
            result.put(u, sug);
        }
        if (!this.isFull() && occ != null && (work = occ.workType) != null && (sug = this.getSuggestion(null, occ.productionType, work)) != null) {
            result.put(null, sug);
        }
        return result;
    }

    public List<AbstractGoods> getInputs() {
        return this.productionType == null ? EMPTY_LIST : this.productionType.getInputs();
    }

    public List<AbstractGoods> getOutputs() {
        return this.productionType == null ? EMPTY_LIST : this.productionType.getOutputs();
    }

    public boolean produces(GoodsType goodsType) {
        return AbstractGoods.containsType(goodsType, this.getOutputs());
    }

    public boolean hasInputs() {
        return this.productionType != null && !this.productionType.getInputs().isEmpty();
    }

    public boolean hasOutputs() {
        return this.productionType != null && !this.productionType.getOutputs().isEmpty();
    }

    public boolean canBeWorked() {
        return this.getNoWorkReason() == UnitLocation.NoAddReason.NONE;
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public List<AbstractGoods> getProduction() {
        ProductionInfo info = this.getProductionInfo();
        return info == null ? EMPTY_LIST : info.getProduction();
    }

    public int getTotalProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("Null GoodsType.");
        }
        return AbstractGoods.getCount(goodsType, this.getProduction());
    }

    public int getMaximumProductionOf(GoodsType goodsType) {
        AbstractGoods ag;
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getMaximumProduction();
        if (production != null && (ag = AbstractGoods.findByType(goodsType, production)) != null) {
            return ag.getAmount();
        }
        return this.getTotalProductionOf(goodsType);
    }

    public UnitType getExpertUnitType() {
        Specification spec = this.getSpecification();
        ProductionType pt = this.getBestProductionType(false, null);
        return pt == null ? null : (UnitType)CollectionUtils.find(CollectionUtils.map(pt.getOutputs(), ag -> spec.getExpertForProducing(ag.getType())), ut -> ut != null, null);
    }

    public int getGenericPotential(GoodsType goodsType) {
        return this.getPotentialProduction(goodsType, this.getSpecification().getDefaultUnitType(this.getOwner()));
    }

    public int getUnitProduction(Unit unit, GoodsType goodsType) {
        if (unit == null || unit.getWorkType() != goodsType) {
            return 0;
        }
        UnitType unitType = unit.getType();
        Turn turn = this.getGame().getTurn();
        int bestAmount = 0;
        for (AbstractGoods output : this.getOutputs()) {
            int amount;
            if (output.getType() != goodsType || bestAmount >= (amount = (int)WorkLocation.applyModifiers(this.getBaseProduction(this.getProductionType(), goodsType, unitType), turn, this.getProductionModifiers(goodsType, unitType)))) continue;
            bestAmount = amount;
        }
        return bestAmount;
    }

    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        return !this.produces(goodsType) ? 0 : Math.max(0, this.getPotentialProduction(goodsType, unit.getType()));
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (!this.canProduce(goodsType, unitType)) {
            return 0;
        }
        if (unitType != null) {
            switch (this.getNoWorkReason()) {
                case NONE: 
                case ALREADY_PRESENT: 
                case CLAIM_REQUIRED: {
                    break;
                }
                case CAPACITY_EXCEEDED: {
                    if (this.getUnitCapacity() > 0) break;
                }
                default: {
                    return 0;
                }
            }
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)WorkLocation.applyModifiers(amount, this.getGame().getTurn(), this.getProductionModifiers(goodsType, unitType))) < 0 ? 0 : amount;
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return this.getOwner() == player ? this.getLocationLabel() : this.getColony().getLocationLabelFor(player);
    }

    @Override
    public final Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public boolean add(Locatable locatable) {
        UnitLocation.NoAddReason reason = this.getNoAddReason(locatable);
        switch (reason) {
            case NONE: {
                break;
            }
            case ALREADY_PRESENT: {
                return true;
            }
            default: {
                throw new IllegalStateException("Can not add " + locatable + " to " + this + " because " + (Object)((Object)reason));
            }
        }
        Unit unit = (Unit)locatable;
        if (!super.add(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.IN_COLONY);
        unit.setMovesLeft(0);
        this.setWorkFor(unit);
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (!this.contains(unit)) {
            return true;
        }
        if (!super.remove(unit)) {
            return false;
        }
        unit.setState(Unit.UnitState.ACTIVE);
        unit.setMovesLeft(0);
        if (this.isEmpty()) {
            this.updateProductionType();
        }
        this.getColony().invalidateCache();
        return true;
    }

    @Override
    public final Settlement getSettlement() {
        return this.colony;
    }

    @Override
    public final int getRank() {
        return Location.getRank(this.getTile());
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isPerson() ? super.getNoAddReason(locatable) : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    public abstract StringTemplate getLabel();

    public abstract boolean isAvailable();

    public abstract boolean isCurrent();

    public abstract UnitLocation.NoAddReason getNoWorkReason();

    public abstract boolean canAutoProduce();

    public abstract boolean canProduce(GoodsType var1, UnitType var2);

    public abstract int getBaseProduction(ProductionType var1, GoodsType var2, UnitType var3);

    public abstract List<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract List<ProductionType> getAvailableProductionTypes(boolean var1);

    public int evaluateFor(Player player) {
        return this.getUnitList().stream().mapToInt(u -> u.evaluateFor(player)).sum();
    }

    public StringTemplate getClaimTemplate() {
        return StringTemplate.name("");
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(COLONY_TAG, this.colony);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.productionType != null) {
            this.productionType.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.colony = xr.findFreeColGameObject(this.getGame(), COLONY_TAG, Colony.class, null, true);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        this.updateProductionType();
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (ProductionType.getXMLElementTagName().equals(tag)) {
            this.productionType = new ProductionType(xr, spec);
        } else {
            super.readChild(xr);
        }
    }

    public static class Suggestion {
        public static final Comparator<Suggestion> descendingAmountComparator = new Comparator<Suggestion>(){

            @Override
            public int compare(Suggestion s1, Suggestion s2) {
                int cmp = s2.amount - s1.amount;
                if (cmp == 0) {
                    cmp = GoodsType.goodsTypeComparator.compare(s1.goodsType, s2.goodsType);
                }
                if (cmp == 0) {
                    cmp = s2.newType.getId().compareTo(s1.newType.getId());
                }
                return cmp;
            }
        };
        public final WorkLocation workLocation;
        public final UnitType oldType;
        public final UnitType newType;
        public final GoodsType goodsType;
        public final int amount;

        public Suggestion(WorkLocation workLocation, UnitType oldType, UnitType newType, GoodsType goodsType, int amount) {
            this.workLocation = workLocation;
            this.oldType = oldType;
            this.newType = newType;
            this.goodsType = goodsType;
            this.amount = amount;
        }
    }
}

