/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmthread.h,v 1.4 2004/01/17 04:06:42 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.4 $
 * $Log: rmthread.h,v $
 * Revision 1.4  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.3  2003/04/05 14:15:03  wes
 * Renamed rmMutexDestroy to rmMutexDelete.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.3  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.2  2001/03/31 17:13:59  wes
 * v1.4.0-alpha-2 checkin
 *
 * Revision 1.1  2000/12/03 23:23:23  wes
 * Initial entry.
 *
 */

#ifndef __rmthread_h_
#define __rmthread_h_

/*
 * this file contains definitions for a platform neutral interface
 * to threads and mutexes. these definitions don't necessarily
 * implement all features of mutexes and threads that you might
 * expect, but enough features are implemented for our purposes:
 * creation of a multistage, multithreaded framework for rendering.
 */

#ifdef RM_X
#include <pthread.h>
#ifndef __NetBSD__
#include <semaphore.h>
#endif
#else  /* RM_WIN */
#include <windows.h>
#include <process.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef RM_X
    
typedef pthread_mutex_t RMmutex;
typedef pthread_t       RMthread;

#else  /* RM_WIN */

typedef HANDLE        RMmutex;
typedef unsigned long RMthread;

#endif

RM_EXPORT_API RMmutex * rmMutexNew(RMenum initLockState);
RM_EXPORT_API RMenum    rmMutexDelete(RMmutex *);
RM_EXPORT_API RMenum    rmMutexLock(RMmutex *);
RM_EXPORT_API RMenum    rmMutexUnlock(RMmutex *);
RM_EXPORT_API RMenum    rmMutexTryLock(RMmutex *toQuery);

RM_EXPORT_API RMenum    rmThreadCreate(RMthread *threadID, void * (*threadFunc)(void *), void *args);
RM_EXPORT_API RMenum    rmThreadJoin (RMthread *threadID, void **threadReturn);


#ifdef __cplusplus
}
#endif

#endif
/* EOF */
