'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Tile command created by George Howlett.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.3 2001/02/17 07:46:19 ghowlett Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.ft CW
.sp
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
.ft R
.sp
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH tile n 2.4 BLT "BLT Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tile \-  Tiling versions of Tk widgets
.SH SYNOPSIS
.sp
\fBtile::button \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::checkbutton \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::frame \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::label \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::radiobutton \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::scrollbar \fIpathName\fR \fIoption value\fR...
.sp
\fBtile::toplevel \fIpathName\fR \fIoption value\fR...
.sp
.BE
.SH DESCRIPTION
The tile widgets let you create textured backgrounds.  The texture is
a Tk image which is tiled over the entire background of the widget.
.SH INTRODUCTION
With the advent of Tk 4.0, images are now easy to create and use in
applications.  Images add interest to applications and they convey
more information.  But one area where Tk hasn't taken advantage of
images is using images as textures for widgets.  Since tiling is a
standard feature of windowing systems, it's very easy to use images 
as textures.
.PP
The tile widgets take the standard Tk 4.0 widgets and add tiling
configuration options to them.  Textures are specified by the name 
of the image you wish to be tiled across the background of the widget.  
.SH EXAMPLE
To add tiling to a widget, you simply create an image using 
Tk's \fBimage\fR command and use the image name as the value for
the \fB\-tile\fR configuration option of the widget.
.CS
image create photo my_texture -file tan_paper.gif
blt::tile::frame .f -tile my_texture
.CE
The image \f(CWmy_texture\fR is added to the frame.  
If \f(CWmy_texture\fR is updated, so will the widget background.
.CS
image create photo my_texture -file rain.gif
.CE
The tile widget commands reside in the "blt::tile" namespace, so
as not to collide with the normal Tk widgets.
An easy way to add tiling to existing programs is to import
the tile widget commands into the global namespace.
.CS
image create photo my_texture -file tan_paper.gif
namespace import -force blt::tile::*
frame .f -tile my_texture
.CE
To use one image for all texturing, you can use the "Tile" option
class name to specify the same image for all tile widgets.
.CS
image create photo my_texture -file tan_paper.gif
option add *Tile my_texture
.CE
.SH OPTIONS
The following configurations options are added to the widgets. If
a \fB\-tile\fB or \fB\-activetile\fR option is specified, it overrides
the background color of the widget.
.TP
\fB\-activetile \fIimage\fR 
Specifies a textured background to display when the widget is active.
This option is available for the \fBtilebutton\fR,
\fBtilecheckbutton\fR, \fBtileradiobutton\fR, and \fBtilescrollbar\fR
widgets.  \fIImage\fR is the name an image created using Tk's
\fBimage\fR command.  The background of the widget is tiled with
\fIimage\fR.  If \fIimage\fR is \f(CW""\fR, then the active background
color is displayed.  The default is \f(CW""\fR.
.TP
\fB\-tile \fIimage\fR 
Specifies a textured background to display for the widget.
\fIImage\fR is the name an image created using Tk's \fBimage\fR
command.  The background of the widget is tiled with \fIimage\fR.  If
\fIimage\fR is \f(CW""\fR, then the normal background color is
displayed.  The default is \f(CW""\fR.
.SH KEYWORDS
tile, texture, button, label, radiobutton, checkbutton, scrollbar, frame, toplevel
