/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation.message.token;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DerivedKeyToken {
    private Log log = LogFactory.getLog((String)(class$org$apache$ws$sandbox$security$conversation$message$token$DerivedKeyToken == null ? (class$org$apache$ws$sandbox$security$conversation$message$token$DerivedKeyToken = DerivedKeyToken.class$("org.apache.ws.sandbox.security.conversation.message.token.DerivedKeyToken")) : class$org$apache$ws$sandbox$security$conversation$message$token$DerivedKeyToken).getName());
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
    protected Element element = null;
    protected Element elementSecurityTokenReference = null;
    protected Element elementProperties = null;
    protected Element elementGeneration = null;
    protected Element elementOffset = null;
    protected Element elementLength = null;
    protected Element elementLabel = null;
    protected Element elementNonce = null;
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$message$token$DerivedKeyToken;

    public DerivedKeyToken(Document doc) {
        this.log.debug((Object)"DerivedKeyToken: created");
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:DerivedKeyToken");
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
    }

    public DerivedKeyToken(Element elem) throws WSSecurityException {
        this.log.debug((Object)"DerivedKeyToken: created : element constructor");
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.elementSecurityTokenReference = (Element)WSSecurityUtil.getDirectChild(this.element, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementProperties = (Element)WSSecurityUtil.getDirectChild(this.element, "Properties", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        this.elementGeneration = (Element)WSSecurityUtil.getDirectChild(this.element, "Generation", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        this.elementOffset = (Element)WSSecurityUtil.getDirectChild(this.element, "Offset", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        this.elementLength = (Element)WSSecurityUtil.getDirectChild(this.element, "Length", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        this.elementLabel = (Element)WSSecurityUtil.getDirectChild(this.element, "Label", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        this.elementNonce = (Element)WSSecurityUtil.getDirectChild(this.element, "Nonce", "http://schemas.xmlsoap.org/ws/2005/02/sc");
    }

    public void setSecuityTokenReference(Document doc, SecurityTokenReference ref) {
        this.elementSecurityTokenReference = ref.getElement();
        this.element.appendChild(ref.getElement());
    }

    public SecurityTokenReference getSecuityTokenReference() throws WSSecurityException {
        if (this.elementSecurityTokenReference != null) {
            return new SecurityTokenReference(this.elementSecurityTokenReference);
        }
        return null;
    }

    private void addProperty(Document doc, String propName, String propValue) {
        if (this.elementProperties == null) {
            this.elementProperties = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Properties");
            WSSecurityUtil.setNamespace(this.elementProperties, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsse");
            this.element.appendChild(this.elementProperties);
        }
        Element tempElement = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:" + propName);
        tempElement.appendChild(doc.createTextNode(propValue));
        this.elementProperties.appendChild(tempElement);
    }

    public void setProperties(Document doc, String name, String label, String nonce) {
        Hashtable<String, String> table = new Hashtable<String, String>(3);
        table.put("Name", name);
        table.put("Label", label);
        table.put("Nonce", nonce);
        this.setProperties(doc, table);
    }

    public void setProperties(Document doc, Hashtable properties) {
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String propertyName = (String)keys.nextElement();
            Node node = WSSecurityUtil.findElement(this.elementProperties, propertyName, "http://schemas.xmlsoap.org/ws/2005/02/sc");
            if (node != null && node instanceof Element) {
                Text node1 = this.getFirstNode((Element)node);
                node1.setData((String)properties.get(propertyName));
                continue;
            }
            this.addProperty(doc, propertyName, (String)properties.get(propertyName));
        }
    }

    public Hashtable getProperties() {
        if (this.elementProperties != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            NodeList nodes = this.elementProperties.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node tempNode = nodes.item(i);
                if (!(tempNode instanceof Element)) continue;
                Text text = this.getFirstNode((Element)tempNode);
                table.put(tempNode.getNodeName(), text.getData());
            }
        }
        return null;
    }

    public void setLength(Document doc, long length) {
        this.elementLength = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Length");
        WSSecurityUtil.setNamespace(this.elementLength, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementLength.appendChild(doc.createTextNode(Long.toString(length)));
        this.element.appendChild(this.elementLength);
    }

    public long getLength() {
        if (this.elementLength != null) {
            return Long.parseLong(this.getFirstNode(this.elementLength).getData());
        }
        return -1L;
    }

    public void setOffset(Document doc, int offset) throws ConversationException {
        if (this.elementGeneration != null) {
            throw new ConversationException("Offset cannot be set along with generation - generation is already set");
        }
        this.elementOffset = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Offset");
        WSSecurityUtil.setNamespace(this.elementOffset, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementOffset.appendChild(doc.createTextNode(Integer.toString(offset)));
        this.element.appendChild(this.elementOffset);
    }

    public int getOffset() {
        if (this.elementOffset != null) {
            return Integer.parseInt(this.getFirstNode(this.elementOffset).getData());
        }
        return -1;
    }

    public void setGeneration(Document doc, int generation) throws ConversationException {
        if (this.elementOffset != null) {
            throw new ConversationException("Generatation cannot be set along with offset - Offset is already set");
        }
        this.elementGeneration = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Generation");
        WSSecurityUtil.setNamespace(this.elementGeneration, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementGeneration.appendChild(doc.createTextNode(Integer.toString(generation)));
        this.element.appendChild(this.elementGeneration);
    }

    public int getGeneration() {
        if (this.elementGeneration != null) {
            return Integer.parseInt(this.getFirstNode(this.elementGeneration).getData());
        }
        return -1;
    }

    public void setLabel(Document doc, String label) {
        this.elementLabel = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Label");
        WSSecurityUtil.setNamespace(this.elementLabel, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementLabel.appendChild(doc.createTextNode(label));
        this.element.appendChild(this.elementLabel);
    }

    public void setNonce(Document doc, String nonce) {
        this.elementNonce = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc:Nonce");
        WSSecurityUtil.setNamespace(this.elementNonce, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.elementNonce.appendChild(doc.createTextNode(nonce));
        this.element.appendChild(this.elementNonce);
    }

    public String getLabel() {
        if (this.elementLabel != null) {
            return this.getFirstNode(this.elementLabel).getData();
        }
        return null;
    }

    public String getNonce() {
        if (this.elementNonce != null) {
            return this.getFirstNode(this.elementNonce).getData();
        }
        return null;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String getAlgorithm() {
        String algo = this.element.getAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", "Algorithm");
        if (algo == null || algo.equals("")) {
            return "http://schemas.xmlsoap.org/ws/2004/04/security/sc/dk/p_sha1";
        }
        return algo;
    }

    public void setAlgorithm(String algo) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2005/02/sc", "wsc");
        this.element.setAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", prefix + ":Algorithm", algo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

