/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.Closeable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public final class LdapUtils {
    public static final Filter OBJECT_CLASS_PRESENCE_FILTER = Filter.createPresenceFilter((String)"objectClass");
    private static final Logger LOGGER = LogManager.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static DN dn(String dn) {
        try {
            return new DN(dn);
        }
        catch (LDAPException e) {
            throw new IllegalArgumentException("invalid DN [" + dn + "]", e);
        }
    }

    public static <T> T privilegedConnect(CheckedSupplier<T, LDAPException> supplier) throws LDAPException {
        SpecialPermission.check();
        try {
            return (T)AccessController.doPrivileged(() -> supplier.get());
        }
        catch (PrivilegedActionException e) {
            throw (LDAPException)e.getCause();
        }
    }

    public static String relativeName(DN dn) {
        return dn.getRDNString().split("=")[1].trim();
    }

    public static String escapedRDNValue(String rdn) {
        return Rdn.escapeValue(rdn);
    }

    private static void maybeForkAndRun(ThreadPool threadPool, Runnable runnable) {
        if (LdapUtils.isLdapConnectionThread(Thread.currentThread())) {
            threadPool.executor("generic").execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static void maybeForkThenBindAndRevert(final LDAPConnectionPool ldapPool, final BindRequest bind, ThreadPool threadPool, final AbstractRunnable runnable) {
        AbstractRunnable bindRunnable = new AbstractRunnable(){

            @SuppressForbidden(reason="Bind allowed if forking of the LDAP Connection Reader Thread.")
            protected void doRun() throws Exception {
                LdapUtils.privilegedConnect(() -> ldapPool.bindAndRevertAuthentication(bind.duplicate()));
                LOGGER.trace("LDAP bind [{}] succeeded for [{}]", (Object)bind, (Object)ldapPool);
                runnable.run();
            }

            public void onFailure(Exception e) {
                LOGGER.debug("LDAP bind [{}] failed for [{}] - [{}]", (Object)bind, (Object)ldapPool, (Object)e.toString());
                runnable.onFailure(e);
            }

            public void onAfter() {
                runnable.onAfter();
            }
        };
        LdapUtils.maybeForkAndRun(threadPool, (Runnable)bindRunnable);
    }

    public static void maybeForkThenBind(final LDAPConnection ldap, final BindRequest bind, ThreadPool threadPool, final AbstractRunnable runnable) {
        AbstractRunnable bindRunnable = new AbstractRunnable(){

            @SuppressForbidden(reason="Bind allowed if forking of the LDAP Connection Reader Thread.")
            protected void doRun() throws Exception {
                LdapUtils.privilegedConnect(() -> ldap.bind(bind.duplicate()));
                LOGGER.trace("LDAP bind [{}] succeeded for [{}]", (Object)bind, (Object)ldap);
                runnable.run();
            }

            public void onFailure(Exception e) {
                LOGGER.debug("LDAP bind [{}] failed for [{}] - [{}]", (Object)bind, (Object)ldap, (Object)e.toString());
                runnable.onFailure(e);
            }

            public void onAfter() {
                runnable.onAfter();
            }
        };
        LdapUtils.maybeForkAndRun(threadPool, (Runnable)bindRunnable);
    }

    public static void searchForEntry(LDAPInterface ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<SearchResultEntry> listener, String ... attributes) {
        if (ldap instanceof LDAPConnection) {
            LdapUtils.searchForEntry((LDAPConnection)ldap, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, listener, attributes);
        } else if (ldap instanceof LDAPConnectionPool) {
            LdapUtils.searchForEntry((LDAPConnectionPool)ldap, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, listener, attributes);
        } else {
            throw new IllegalArgumentException("unsupported LDAPInterface implementation: " + ldap);
        }
    }

    public static void searchForEntry(LDAPConnection ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<SearchResultEntry> listener, String ... attributes) {
        SingleEntryListener searchResultListener = new SingleEntryListener(ldap, listener, filter, ignoreReferralErrors);
        try {
            SearchRequest request = new SearchRequest((SearchResultListener)searchResultListener, baseDN, scope, DereferencePolicy.NEVER, 0, timeLimitSeconds, false, filter, attributes);
            searchResultListener.setSearchRequest(request);
            ldap.asyncSearch(request);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchForEntry(LDAPConnectionPool ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<SearchResultEntry> listener, String ... attributes) {
        block5: {
            LDAPConnection finalConnection;
            boolean searching = false;
            LDAPConnection ldapConnection = null;
            try {
                finalConnection = ldapConnection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)ldap).getConnection());
                LdapUtils.searchForEntry(finalConnection, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    assert (LdapUtils.isLdapConnectionThread(Thread.currentThread())) : "Expected current thread [" + Thread.currentThread() + "] to be an LDAPConnectionReader Thread. Probably the new library has changed the thread's name.";
                    IOUtils.close((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onResponse(entry);
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onFailure(e);
                }), attributes);
                searching = true;
                if (searching) break block5;
                finalConnection = ldapConnection;
            }
            catch (LDAPException e2) {
                LDAPConnection finalConnection2;
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (searching) break block5;
                    finalConnection2 = ldapConnection;
                }
                catch (Throwable throwable) {
                    if (!searching) {
                        LDAPConnection finalConnection3 = ldapConnection;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
        }
    }

    public static void search(LDAPInterface ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        if (ldap instanceof LDAPConnection) {
            LdapUtils.search((LDAPConnection)ldap, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, listener, attributes);
        } else if (ldap instanceof LDAPConnectionPool) {
            LdapUtils.search((LDAPConnectionPool)ldap, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, listener, attributes);
        } else {
            throw new IllegalArgumentException("unsupported LDAPInterface implementation: " + ldap);
        }
    }

    public static void search(LDAPConnection ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        LdapSearchResultListener searchResultListener = new LdapSearchResultListener(ldap, ignoreReferralErrors, (ActionListener<SearchResult>)ActionListener.wrap(searchResult -> {
            assert (LdapUtils.isLdapConnectionThread(Thread.currentThread())) : "Expected current thread [" + Thread.currentThread() + "] to be an LDAPConnectionReader Thread. Probably the new library has changed the thread's name.";
            listener.onResponse(Collections.unmodifiableList(searchResult.getSearchEntries()));
        }, arg_0 -> listener.onFailure(arg_0)), 1);
        try {
            SearchRequest request = new SearchRequest((SearchResultListener)searchResultListener, baseDN, scope, DereferencePolicy.NEVER, 0, timeLimitSeconds, false, filter, attributes);
            searchResultListener.setSearchRequest(request);
            ldap.asyncSearch(request);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void search(LDAPConnectionPool ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, boolean ignoreReferralErrors, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        block5: {
            LDAPConnection finalConnection;
            boolean searching = false;
            LDAPConnection ldapConnection = null;
            try {
                finalConnection = ldapConnection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((LDAPConnectionPool)ldap).getConnection());
                LdapUtils.search(finalConnection, baseDN, scope, filter, timeLimitSeconds, ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(searchResult -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onResponse(searchResult);
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onFailure(e);
                }), attributes);
                searching = true;
                if (searching || ldapConnection == null) break block5;
                finalConnection = ldapConnection;
            }
            catch (LDAPException e2) {
                LDAPConnection finalConnection2;
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (searching || ldapConnection == null) break block5;
                    finalConnection2 = ldapConnection;
                }
                catch (Throwable throwable) {
                    if (!searching && ldapConnection != null) {
                        LDAPConnection finalConnection3 = ldapConnection;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
        }
    }

    static boolean isLdapConnectionThread(Thread thread) {
        return Thread.currentThread().getName().startsWith("Connection reader for connection ");
    }

    private static boolean isSuccess(SearchResult searchResult) {
        switch (searchResult.getResultCode().intValue()) {
            case 0: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private static SearchResult emptyResult(SearchResult parentResult) {
        return new SearchResult(parentResult.getMessageID(), ResultCode.SUCCESS, "Empty result", parentResult.getMatchedDN(), null, 0, 0, null);
    }

    private static LDAPException toException(SearchResult searchResult) {
        return new LDAPException(searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), searchResult.getReferralURLs(), searchResult.getResponseControls());
    }

    public static Filter createFilter(String filterTemplate, String ... arguments) throws LDAPException {
        return Filter.create((String)new MessageFormat(filterTemplate, Locale.ROOT).format(LdapUtils.encodeFilterValues(arguments), new StringBuffer(), (FieldPosition)null).toString());
    }

    public static String[] attributesToSearchFor(String[] attributes) {
        String[] stringArray;
        if (attributes == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "1.1";
        } else {
            stringArray = attributes;
        }
        return stringArray;
    }

    public static String[] attributesToSearchFor(String[] ... args) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (String[] array : args) {
            if (array == null) continue;
            attributes.addAll(Arrays.asList(array));
        }
        return attributes.isEmpty() ? LdapUtils.attributesToSearchFor((String[])null) : attributes.toArray(new String[attributes.size()]);
    }

    private static String[] encodeFilterValues(String ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Filter.encodeValue((String)arguments[i]);
        }
        return arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void followReferral(LDAPConnection ldapConnection, String urlString, SearchRequest searchRequest, ActionListener<SearchResult> listener, int depth, boolean ignoreErrors, SearchResult originatingResult) throws LDAPException {
        LDAPURL referralURL = new LDAPURL(urlString);
        String host = referralURL.getHost();
        if (host == null) {
            throw new LDAPException(ResultCode.UNAVAILABLE, "Null referral host in " + urlString);
        }
        String requestBaseDN = referralURL.baseDNProvided() ? referralURL.getBaseDN().toString() : searchRequest.getBaseDN();
        SearchScope requestScope = referralURL.scopeProvided() ? referralURL.getScope() : searchRequest.getScope();
        Filter requestFilter = referralURL.filterProvided() ? referralURL.getFilter() : searchRequest.getFilter();
        LDAPConnection referralConn = (LDAPConnection)LdapUtils.privilegedConnect(() -> ldapConnection.getReferralConnector().getReferralConnection(referralURL, ldapConnection));
        LdapSearchResultListener ldapListener = new LdapSearchResultListener(referralConn, ignoreErrors, (ActionListener<SearchResult>)ActionListener.wrap(searchResult -> {
            IOUtils.close((Closeable[])new Closeable[]{referralConn});
            listener.onResponse(searchResult);
        }, e -> {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{referralConn});
            if (ignoreErrors) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Message)new ParameterizedMessage("Failed to retrieve results from referral URL [{}]. Treating as 'no results'", (Object)referralURL), (Throwable)e);
                }
                listener.onResponse((Object)LdapUtils.emptyResult(originatingResult));
            } else {
                listener.onFailure(e);
            }
        }), depth);
        boolean success = false;
        try {
            SearchRequest referralSearchRequest = new SearchRequest((SearchResultListener)ldapListener, searchRequest.getControls(), requestBaseDN, requestScope, searchRequest.getDereferencePolicy(), searchRequest.getSizeLimit(), searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), requestFilter, searchRequest.getAttributes());
            ldapListener.setSearchRequest(searchRequest);
            referralConn.asyncSearch(referralSearchRequest);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{referralConn});
            throw throwable;
        }
    }

    private static class LdapSearchResultListener
    implements AsyncSearchResultListener {
        private final List<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>();
        private final List<SearchResultReference> referenceList = new ArrayList<SearchResultReference>();
        protected final SetOnce<SearchRequest> searchRequestRef = new SetOnce();
        private final LDAPConnection ldapConnection;
        private final boolean ignoreReferralErrors;
        private final ActionListener<SearchResult> listener;
        private final int depth;

        LdapSearchResultListener(LDAPConnection ldapConnection, boolean ignoreReferralErrors, ActionListener<SearchResult> listener, int depth) {
            this.ldapConnection = ldapConnection;
            this.listener = listener;
            this.depth = depth;
            this.ignoreReferralErrors = ignoreReferralErrors;
        }

        public void searchEntryReturned(SearchResultEntry searchEntry) {
            this.entryList.add(searchEntry);
        }

        public void searchReferenceReturned(SearchResultReference searchReference) {
            this.referenceList.add(searchReference);
        }

        public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
            Object[] referralUrls = this.referenceList.stream().flatMap(ref -> Arrays.stream(ref.getReferralURLs())).collect(Collectors.toList()).toArray(Strings.EMPTY_ARRAY);
            SearchRequest request = (SearchRequest)this.searchRequestRef.get();
            if (referralUrls.length == 0 || !request.followReferrals(this.ldapConnection)) {
                LOGGER.trace("LDAP Search {} => {} ({})", (Object)request, (Object)searchResult, this.entryList);
                if (LdapUtils.isSuccess(searchResult)) {
                    SearchResult resultWithValues = new SearchResult(searchResult.getMessageID(), searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), (String[])referralUrls, this.entryList, this.referenceList, this.entryList.size(), this.referenceList.size(), searchResult.getResponseControls());
                    this.listener.onResponse((Object)resultWithValues);
                } else {
                    this.listener.onFailure((Exception)((Object)LdapUtils.toException(searchResult)));
                }
            } else if (this.depth >= this.ldapConnection.getConnectionOptions().getReferralHopLimit()) {
                LOGGER.trace("Referral limit exceeded {} => {} ({})", (Object)request, (Object)searchResult, this.entryList);
                this.listener.onFailure((Exception)((Object)new LDAPException(ResultCode.REFERRAL_LIMIT_EXCEEDED, "Referral limit exceeded (" + this.depth + ")", searchResult.getMatchedDN(), (String[])referralUrls, searchResult.getResponseControls())));
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("LDAP referred elsewhere {} => {}", (Object)request, (Object)Arrays.toString(referralUrls));
                }
                CountDown countDown = new CountDown(referralUrls.length);
                ArrayList<Object> referralUrlsList = new ArrayList<Object>(Arrays.asList(referralUrls));
                ActionListener referralListener = ActionListener.wrap(innerResult -> {
                    LdapSearchResultListener ldapSearchResultListener = this;
                    synchronized (ldapSearchResultListener) {
                        if (innerResult.getSearchEntries() != null) {
                            this.entryList.addAll(innerResult.getSearchEntries());
                        }
                        if (innerResult.getSearchReferences() != null) {
                            this.referenceList.addAll(innerResult.getSearchReferences());
                        }
                    }
                    if (countDown.countDown()) {
                        SearchResult resultWithValues = new SearchResult(searchResult.getMessageID(), searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), referralUrlsList.toArray(Strings.EMPTY_ARRAY), this.entryList, this.referenceList, this.entryList.size(), this.referenceList.size(), searchResult.getResponseControls());
                        this.listener.onResponse((Object)resultWithValues);
                    }
                }, arg_0 -> this.listener.onFailure(arg_0));
                for (Object referralUrl : referralUrls) {
                    try {
                        LdapUtils.followReferral(this.ldapConnection, (String)referralUrl, request, (ActionListener<SearchResult>)referralListener, this.depth + 1, this.ignoreReferralErrors, searchResult);
                    }
                    catch (LDAPException e) {
                        LOGGER.warn(() -> LdapSearchResultListener.lambda$searchResultReceived$2((String)referralUrl), (Throwable)e);
                        if (this.ignoreReferralErrors) {
                            referralListener.onResponse((Object)LdapUtils.emptyResult(searchResult));
                            continue;
                        }
                        this.listener.onFailure((Exception)((Object)e));
                    }
                }
            }
        }

        void setSearchRequest(SearchRequest searchRequest) {
            this.searchRequestRef.set((Object)searchRequest);
        }

        private static /* synthetic */ Object lambda$searchResultReceived$2(String referralUrl) {
            return new ParameterizedMessage("caught exception while trying to follow referral [{}]", (Object)referralUrl);
        }
    }

    private static class SingleEntryListener
    extends LdapSearchResultListener {
        SingleEntryListener(LDAPConnection ldapConnection, ActionListener<SearchResultEntry> listener, Filter filter, boolean ignoreReferralErrors) {
            super(ldapConnection, ignoreReferralErrors, (ActionListener<SearchResult>)ActionListener.wrap(searchResult -> {
                List entryList = searchResult.getSearchEntries();
                if (entryList.size() > 1) {
                    listener.onFailure((Exception)Exceptions.authenticationError((String)"multiple search results found for [{}]", (Object[])new Object[]{filter}));
                } else if (entryList.size() == 1) {
                    listener.onResponse((Object)((SearchResultEntry)entryList.get(0)));
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)), 1);
        }
    }
}

