/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.writer;

import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.InsertBase;
import htsjdk.samtools.cram.encoding.readfeatures.Insertion;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadBase;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.SoftClip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.encoding.writer.DataSeriesWriter;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.DataSeries;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.SliceBlocks;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CramRecordWriter {
    private final DataSeriesWriter<Integer> bitFlagsCodec;
    private final DataSeriesWriter<Integer> cramBitFlagsCodec;
    private final DataSeriesWriter<Integer> readLengthCodec;
    private final DataSeriesWriter<Integer> alignmentStartCodec;
    private final DataSeriesWriter<Integer> readGroupCodec;
    private final DataSeriesWriter<byte[]> readNameCodec;
    private final DataSeriesWriter<Integer> distanceToNextFragmentCodec;
    private final Map<Integer, DataSeriesWriter<byte[]>> tagValueCodecs;
    private final DataSeriesWriter<Integer> numberOfReadFeaturesCodec;
    private final DataSeriesWriter<Integer> featurePositionCodec;
    private final DataSeriesWriter<Byte> featuresCodeCodec;
    private final DataSeriesWriter<Byte> baseCodec;
    private final DataSeriesWriter<Byte> qualityScoreCodec;
    private final DataSeriesWriter<byte[]> qualityScoreArrayCodec;
    private final DataSeriesWriter<Byte> baseSubstitutionCodeCodec;
    private final DataSeriesWriter<byte[]> insertionCodec;
    private final DataSeriesWriter<byte[]> softClipCodec;
    private final DataSeriesWriter<Integer> hardClipCodec;
    private final DataSeriesWriter<Integer> paddingCodec;
    private final DataSeriesWriter<Integer> deletionLengthCodec;
    private final DataSeriesWriter<Integer> mappingQualityScoreCodec;
    private final DataSeriesWriter<Integer> mateBitFlagsCodec;
    private final DataSeriesWriter<Integer> nextFragmentReferenceSequenceIDCodec;
    private final DataSeriesWriter<Integer> nextFragmentAlignmentStart;
    private final DataSeriesWriter<Integer> templateSize;
    private final DataSeriesWriter<Integer> tagIdListCodec;
    private final DataSeriesWriter<Integer> refIdCodec;
    private final DataSeriesWriter<Integer> refSkipCodec;
    private static final Charset charset = StandardCharsets.UTF_8;
    private final Slice slice;
    private final CompressionHeader compressionHeader;
    private final SliceBlocksWriteStreams sliceBlocksWriteStreams;

    public CramRecordWriter(Slice slice) {
        this.slice = slice;
        this.compressionHeader = slice.getCompressionHeader();
        this.sliceBlocksWriteStreams = new SliceBlocksWriteStreams(this.compressionHeader);
        this.bitFlagsCodec = this.createDataWriter(DataSeries.BF_BitFlags);
        this.cramBitFlagsCodec = this.createDataWriter(DataSeries.CF_CompressionBitFlags);
        this.readLengthCodec = this.createDataWriter(DataSeries.RL_ReadLength);
        this.alignmentStartCodec = this.createDataWriter(DataSeries.AP_AlignmentPositionOffset);
        this.readGroupCodec = this.createDataWriter(DataSeries.RG_ReadGroup);
        this.readNameCodec = this.createDataWriter(DataSeries.RN_ReadName);
        this.distanceToNextFragmentCodec = this.createDataWriter(DataSeries.NF_RecordsToNextFragment);
        this.numberOfReadFeaturesCodec = this.createDataWriter(DataSeries.FN_NumberOfReadFeatures);
        this.featurePositionCodec = this.createDataWriter(DataSeries.FP_FeaturePosition);
        this.featuresCodeCodec = this.createDataWriter(DataSeries.FC_FeatureCode);
        this.baseCodec = this.createDataWriter(DataSeries.BA_Base);
        this.qualityScoreCodec = this.createDataWriter(DataSeries.QS_QualityScore);
        this.baseSubstitutionCodeCodec = this.createDataWriter(DataSeries.BS_BaseSubstitutionCode);
        this.insertionCodec = this.createDataWriter(DataSeries.IN_Insertion);
        this.softClipCodec = this.createDataWriter(DataSeries.SC_SoftClip);
        this.hardClipCodec = this.createDataWriter(DataSeries.HC_HardClip);
        this.paddingCodec = this.createDataWriter(DataSeries.PD_padding);
        this.deletionLengthCodec = this.createDataWriter(DataSeries.DL_DeletionLength);
        this.mappingQualityScoreCodec = this.createDataWriter(DataSeries.MQ_MappingQualityScore);
        this.mateBitFlagsCodec = this.createDataWriter(DataSeries.MF_MateBitFlags);
        this.nextFragmentReferenceSequenceIDCodec = this.createDataWriter(DataSeries.NS_NextFragmentReferenceSequenceID);
        this.nextFragmentAlignmentStart = this.createDataWriter(DataSeries.NP_NextFragmentAlignmentStart);
        this.templateSize = this.createDataWriter(DataSeries.TS_InsertSize);
        this.tagIdListCodec = this.createDataWriter(DataSeries.TL_TagIdList);
        this.refIdCodec = this.createDataWriter(DataSeries.RI_RefId);
        this.refSkipCodec = this.createDataWriter(DataSeries.RS_RefSkip);
        this.qualityScoreArrayCodec = new DataSeriesWriter(DataSeriesType.BYTE_ARRAY, this.compressionHeader.getEncodingMap().getEncodingDescriptorForDataSeries(DataSeries.QS_QualityScore), this.sliceBlocksWriteStreams);
        this.tagValueCodecs = this.compressionHeader.getTagEncodingMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapEntry -> new DataSeriesWriter(DataSeriesType.BYTE_ARRAY, (EncodingDescriptor)mapEntry.getValue(), this.sliceBlocksWriteStreams)));
    }

    public SliceBlocks writeToSliceBlocks(List<CRAMCompressionRecord> records, int initialAlignmentStart) {
        int prevAlignmentStart = initialAlignmentStart;
        for (CRAMCompressionRecord record : records) {
            this.writeCRAMRecord(record, prevAlignmentStart);
            prevAlignmentStart = record.getAlignmentStart();
        }
        return this.sliceBlocksWriteStreams.flushStreamsToBlocks();
    }

    private <T> DataSeriesWriter<T> createDataWriter(DataSeries dataSeries) {
        EncodingDescriptor encodingDescriptor = this.compressionHeader.getEncodingMap().getEncodingDescriptorForDataSeries(dataSeries);
        if (encodingDescriptor == null) {
            throw new IllegalArgumentException(String.format("Attempt to create data series writer for data series %s for which no encoding can be found", new Object[]{dataSeries}));
        }
        return new DataSeriesWriter(dataSeries.getType(), encodingDescriptor, this.sliceBlocksWriteStreams);
    }

    private void writeCRAMRecord(CRAMCompressionRecord r, int prevAlignmentStart) {
        this.bitFlagsCodec.writeData(r.getBAMFlags());
        this.cramBitFlagsCodec.writeData(r.getCRAMFlags());
        if (this.slice.getAlignmentContext().getReferenceContext().isMultiRef()) {
            this.refIdCodec.writeData(r.getReferenceIndex());
        }
        this.readLengthCodec.writeData(r.getReadLength());
        if (this.compressionHeader.isAPDelta()) {
            int alignmentDelta = r.getAlignmentStart() - prevAlignmentStart;
            this.alignmentStartCodec.writeData(alignmentDelta);
        } else {
            this.alignmentStartCodec.writeData(r.getAlignmentStart());
        }
        this.readGroupCodec.writeData(r.getReadGroupID());
        if (this.compressionHeader.isPreserveReadNames()) {
            this.readNameCodec.writeData(r.getReadName().getBytes(charset));
        }
        if (r.isDetached()) {
            this.mateBitFlagsCodec.writeData(r.getMateFlags());
            if (!this.compressionHeader.isPreserveReadNames()) {
                this.readNameCodec.writeData(r.getReadName().getBytes(charset));
            }
            this.nextFragmentReferenceSequenceIDCodec.writeData(r.getMateReferenceIndex());
            this.nextFragmentAlignmentStart.writeData(r.getMateAlignmentStart());
            this.templateSize.writeData(r.getTemplateSize());
        } else if (r.isHasMateDownStream()) {
            this.distanceToNextFragmentCodec.writeData(r.getRecordsToNextFragment());
        }
        this.tagIdListCodec.writeData(r.getTagIdsIndex().value);
        if (r.getTags() != null) {
            for (int i = 0; i < r.getTags().size(); ++i) {
                DataSeriesWriter<byte[]> writer = this.tagValueCodecs.get(r.getTags().get((int)i).keyType3BytesAsInt);
                writer.writeData(r.getTags().get(i).getValueAsByteArray());
            }
        }
        if (!r.isSegmentUnmapped()) {
            int featuresSize = r.getReadFeatures() == null ? 0 : r.getReadFeatures().size();
            this.numberOfReadFeaturesCodec.writeData(featuresSize);
            if (featuresSize != 0) {
                int prevPos = 0;
                block13: for (ReadFeature f : r.getReadFeatures()) {
                    this.featuresCodeCodec.writeData(f.getOperator());
                    this.featurePositionCodec.writeData(f.getPosition() - prevPos);
                    prevPos = f.getPosition();
                    switch (f.getOperator()) {
                        case 66: {
                            ReadBase rb = (ReadBase)f;
                            this.baseCodec.writeData(rb.getBase());
                            this.qualityScoreCodec.writeData(rb.getQualityScore());
                            continue block13;
                        }
                        case 88: {
                            Substitution sv = (Substitution)f;
                            if (sv.getCode() < 0) {
                                this.baseSubstitutionCodeCodec.writeData(this.compressionHeader.getSubstitutionMatrix().code(sv.getReferenceBase(), sv.getBase()));
                                continue block13;
                            }
                            this.baseSubstitutionCodeCodec.writeData(sv.getCode());
                            continue block13;
                        }
                        case 73: {
                            Insertion iv = (Insertion)f;
                            this.insertionCodec.writeData(iv.getSequence());
                            continue block13;
                        }
                        case 83: {
                            SoftClip fv = (SoftClip)f;
                            this.softClipCodec.writeData(fv.getSequence());
                            continue block13;
                        }
                        case 72: {
                            HardClip hv = (HardClip)f;
                            this.hardClipCodec.writeData(hv.getLength());
                            continue block13;
                        }
                        case 80: {
                            Padding pv = (Padding)f;
                            this.paddingCodec.writeData(pv.getLength());
                            continue block13;
                        }
                        case 68: {
                            Deletion dv = (Deletion)f;
                            this.deletionLengthCodec.writeData(dv.getLength());
                            continue block13;
                        }
                        case 78: {
                            RefSkip rsv = (RefSkip)f;
                            this.refSkipCodec.writeData(rsv.getLength());
                            continue block13;
                        }
                        case 105: {
                            InsertBase ib = (InsertBase)f;
                            this.baseCodec.writeData(ib.getBase());
                            continue block13;
                        }
                        case 81: {
                            BaseQualityScore bqs = (BaseQualityScore)f;
                            this.qualityScoreCodec.writeData(bqs.getQualityScore());
                            continue block13;
                        }
                    }
                    throw new RuntimeException("Unknown read feature operator: " + (char)f.getOperator());
                }
            }
            this.mappingQualityScoreCodec.writeData(r.getMappingQuality());
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.getQualityScores());
            }
        } else {
            if (!r.isUnknownBases()) {
                for (byte b : r.getReadBases()) {
                    this.baseCodec.writeData(b);
                }
            }
            if (r.isForcePreserveQualityScores()) {
                this.qualityScoreArrayCodec.writeData(r.getQualityScores());
            }
        }
    }
}

