/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.plugin.PluginUIListener;
import free.util.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class PluginContainersMenu
extends JMenu
implements PluginUIListener,
ActionListener {
    private final Hashtable containersToVisCheckBoxes = new Hashtable();
    private final Hashtable visCheckBoxesToContainers = new Hashtable();
    private final Hashtable containersToActiveRadioButtons = new Hashtable();
    private final Hashtable activeRadioButtonsToContainers = new Hashtable();
    private final Vector items = new Vector();
    private int sepIndex = -1;

    public PluginContainersMenu() {
        this(Utilities.EMPTY_ENUM);
    }

    public PluginContainersMenu(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.pluginContainerAdded((PluginUIContainer)enumeration.nextElement());
        }
    }

    private void syncMenus() {
        this.removeAll();
        for (int i = 0; i < this.items.size(); ++i) {
            Object e = this.items.elementAt(i);
            if (e instanceof JMenuItem) {
                this.add((JMenuItem)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            this.addSeparator();
        }
    }

    private void syncShowCheckBoxText(JCheckBoxMenuItem jCheckBoxMenuItem, PluginUIContainer pluginUIContainer) {
        I18n i18n = I18n.get(PluginContainersMenu.class);
        jCheckBoxMenuItem.setText(i18n.getFormattedString("showPluginContainerCheckBox.text", new Object[]{pluginUIContainer.getTitle()}));
    }

    public void pluginContainerAdded(PluginUIContainer pluginUIContainer) {
        JMenuItem jMenuItem;
        if (pluginUIContainer.getMode() == 1) {
            jMenuItem = new JCheckBoxMenuItem();
            jMenuItem.setSelected(pluginUIContainer.isVisible());
            this.syncShowCheckBoxText((JCheckBoxMenuItem)jMenuItem, pluginUIContainer);
            this.containersToVisCheckBoxes.put(pluginUIContainer, jMenuItem);
            this.visCheckBoxesToContainers.put(jMenuItem, pluginUIContainer);
            jMenuItem.addActionListener(this);
            this.addShowCheckBox((JCheckBoxMenuItem)jMenuItem);
        }
        jMenuItem = new JRadioButtonMenuItem(pluginUIContainer.getTitle(), pluginUIContainer.isActive());
        this.containersToActiveRadioButtons.put(pluginUIContainer, jMenuItem);
        this.activeRadioButtonsToContainers.put(jMenuItem, pluginUIContainer);
        if (pluginUIContainer.isVisible()) {
            this.addActiveRadioButton((JRadioButtonMenuItem)jMenuItem);
        }
        jMenuItem.addActionListener(this);
        pluginUIContainer.addPluginUIListener(this);
    }

    private void addShowCheckBox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        if (this.sepIndex != -1) {
            this.items.insertElementAt(jCheckBoxMenuItem, this.sepIndex++);
        } else if (this.activeRadioButtonsToContainers.size() != 0) {
            this.items.insertElementAt(jCheckBoxMenuItem, 0);
            this.sepIndex = 1;
            this.items.insertElementAt(new JSeparator(), 1);
        } else {
            this.items.addElement(jCheckBoxMenuItem);
        }
        this.syncMenus();
    }

    private void removeShowCheckBox(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this.items.removeElement(jCheckBoxMenuItem);
        if (this.sepIndex != -1) {
            --this.sepIndex;
        }
        if (this.sepIndex == 0) {
            this.items.removeElementAt(0);
            this.sepIndex = -1;
        }
        this.syncMenus();
    }

    private void addActiveRadioButton(JRadioButtonMenuItem jRadioButtonMenuItem) {
        if (this.sepIndex != -1) {
            this.items.addElement(jRadioButtonMenuItem);
        } else if (this.visCheckBoxesToContainers.size() != 0) {
            this.sepIndex = this.items.size();
            this.items.addElement(new JSeparator());
            this.items.addElement(jRadioButtonMenuItem);
        } else {
            this.items.addElement(jRadioButtonMenuItem);
        }
        this.syncMenus();
    }

    private void removeActiveRadioButton(JRadioButtonMenuItem jRadioButtonMenuItem) {
        this.items.removeElement(jRadioButtonMenuItem);
        if (this.sepIndex != -1 && this.sepIndex == this.items.size() - 1) {
            this.items.removeElementAt(this.sepIndex);
            this.sepIndex = -1;
        }
        this.syncMenus();
    }

    public void pluginUIShown(PluginUIEvent pluginUIEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.containersToVisCheckBoxes.get(pluginUIEvent.getSource());
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setState(true);
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.get(pluginUIEvent.getSource());
        this.addActiveRadioButton(jRadioButtonMenuItem);
    }

    public void pluginUIHidden(PluginUIEvent pluginUIEvent) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.containersToVisCheckBoxes.get(pluginUIEvent.getSource());
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setState(false);
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.get(pluginUIEvent.getSource());
        this.removeActiveRadioButton(jRadioButtonMenuItem);
    }

    public void pluginUIActivated(PluginUIEvent pluginUIEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.get(pluginUIEvent.getSource());
        jRadioButtonMenuItem.setSelected(true);
    }

    public void pluginUIDeactivated(PluginUIEvent pluginUIEvent) {
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.get(pluginUIEvent.getSource());
        jRadioButtonMenuItem.setSelected(false);
    }

    public void pluginUIDisposed(PluginUIEvent pluginUIEvent) {
        this.pluginContainerRemoved(pluginUIEvent.getPluginUIContainer());
    }

    public void pluginUITitleChanged(PluginUIEvent pluginUIEvent) {
        PluginUIContainer pluginUIContainer = pluginUIEvent.getPluginUIContainer();
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.containersToVisCheckBoxes.get(pluginUIContainer);
        if (jCheckBoxMenuItem != null) {
            this.syncShowCheckBoxText(jCheckBoxMenuItem, pluginUIContainer);
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.get(pluginUIContainer);
        jRadioButtonMenuItem.setText(pluginUIContainer.getTitle());
    }

    public void pluginUIClosing(PluginUIEvent pluginUIEvent) {
    }

    public void pluginUIIconChanged(PluginUIEvent pluginUIEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
            PluginUIContainer pluginUIContainer = (PluginUIContainer)this.visCheckBoxesToContainers.get(jCheckBoxMenuItem);
            pluginUIContainer.setVisible(jCheckBoxMenuItem.isSelected());
        } else if (object instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object;
            PluginUIContainer pluginUIContainer = (PluginUIContainer)this.activeRadioButtonsToContainers.get(jRadioButtonMenuItem);
            pluginUIContainer.setActive(jRadioButtonMenuItem.isSelected());
        }
    }

    private void pluginContainerRemoved(PluginUIContainer pluginUIContainer) {
        JMenuItem jMenuItem;
        if (pluginUIContainer.getMode() == 1) {
            jMenuItem = (JCheckBoxMenuItem)this.containersToVisCheckBoxes.remove(pluginUIContainer);
            this.visCheckBoxesToContainers.remove(jMenuItem);
            this.removeShowCheckBox((JCheckBoxMenuItem)jMenuItem);
        }
        jMenuItem = (JRadioButtonMenuItem)this.containersToActiveRadioButtons.remove(pluginUIContainer);
        this.activeRadioButtonsToContainers.remove(jMenuItem);
        this.removeActiveRadioButton((JRadioButtonMenuItem)jMenuItem);
        pluginUIContainer.removePluginUIListener(this);
    }
}

