/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.kriegspiel;

import free.chess.ChessPiece;
import free.chess.Move;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;

public class KriegspielMove
extends Move {
    private final ChessPiece capturedPiece;

    public KriegspielMove(Player player, String string) {
        super(null, null, player, string);
        this.capturedPiece = null;
    }

    public KriegspielMove(Position position, Square square, String string) {
        super(null, square, position.getCurrentPlayer(), string);
        this.capturedPiece = (ChessPiece)position.getPieceAt(square);
        if (this.capturedPiece == null) {
            throw new IllegalArgumentException("A partially hidden move must be a capture");
        }
    }

    public boolean isCompletelyHidden() {
        return super.getEndingSquare() == null;
    }

    public Square getStartingSquare() {
        return null;
    }

    public Square getEndingSquare() {
        if (this.isCompletelyHidden()) {
            return null;
        }
        return super.getEndingSquare();
    }

    public String getMoveString() {
        if (this.isCompletelyHidden()) {
            return "?";
        }
        return "?x" + this.getEndingSquare().toString();
    }
}

