/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.BlockingQueue;
import free.util.audio.AudioClip;
import free.util.audio.AudioPlayer;
import java.applet.AppletContext;

public class AppletContextAudioPlayer
implements AudioPlayer,
Runnable {
    private static AppletContext appletContext = null;
    private Thread playerThread = null;
    private final BlockingQueue clipQueue = new BlockingQueue();

    public boolean isSupported() {
        return AppletContextAudioPlayer.getAppletContext() != null;
    }

    public static synchronized void setAppletContext(AppletContext appletContext) {
        if (appletContext == null) {
            throw new IllegalArgumentException("The specified AppletContext may not be null");
        }
        AppletContextAudioPlayer.appletContext = appletContext;
    }

    public static synchronized AppletContext getAppletContext() {
        return appletContext;
    }

    public synchronized void play(AudioClip audioClip) {
        if (this.playerThread == null) {
            this.playerThread = new Thread((Runnable)this, "AppletContextAudioPlayer");
            this.playerThread.setDaemon(true);
            this.playerThread.start();
        }
        this.clipQueue.push(audioClip);
    }

    public void run() {
        try {
            while (true) {
                AudioClip audioClip = (AudioClip)this.clipQueue.pop();
                AppletContextAudioPlayer.getAppletContext().getAudioClip(audioClip.getURL()).play();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }
}

