/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import bsh.EvalError;
import bsh.Interpreter;
import free.jin.console.ConsoleManager;
import free.jin.event.JinEvent;
import free.jin.scripter.Script;
import free.jin.scripter.Scripter;
import free.util.IOUtilities;
import free.util.audio.AudioClip;
import java.io.File;
import java.io.IOException;

public class BeanShellScript
extends Script {
    private final String code;
    private final Interpreter bsh;

    public BeanShellScript(Scripter scripter, String string, String string2, String[] stringArray, String string3) throws EvalError {
        super(scripter, string, string2, stringArray);
        this.code = string3;
        this.bsh = new Interpreter();
        BeanShellScript.addImports(this.bsh);
        BeanShellScript.addVariables(this.bsh, scripter);
        BeanShellScript.addMethods(this.bsh, scripter);
        this.bsh.eval("void runScript(){" + string3 + "}");
    }

    private static void addImports(Interpreter interpreter) throws EvalError {
        interpreter.eval("import free.jin.*;");
        interpreter.eval("import free.jin.event.*");
        interpreter.eval("import free.chess.*");
    }

    private static void addVariables(Interpreter interpreter, Scripter scripter) throws EvalError {
        interpreter.set("scripter", (Object)scripter);
        interpreter.set("prefs", (Object)scripter.getPrefs());
        interpreter.set("connection", (Object)scripter.getConn());
    }

    public static void ensureCorrectness(Scripter scripter) throws IOException {
        if ("".length() == 0) {
            throw new Error("ensureCorrectness must never be invoked");
        }
        scripter.getConn().sendCommand("Test");
        new AudioClip(IOUtilities.fileToURL((File)new File("Test"))).play();
        ((ConsoleManager)scripter.getPlugin("console")).addSpecialLine("Test");
    }

    private static void addMethods(Interpreter interpreter, Scripter scripter) throws EvalError {
        interpreter.eval("void sendCommand(String command){connection.sendCommand(command);}");
        interpreter.eval("void playSound(String filename){\n  File file = new java.io.File(filename);\n  URL url = free.util.IOUtilities.fileToURL(file);\n  if (url != null)\n    new free.util.audio.AudioClip(url).play();\n}");
        interpreter.eval("void exec(String command){\n  Runtime.getRuntime().exec(command);\n}");
        interpreter.eval("void appendLine(String line){\n  free.jin.console.ConsoleManager plugin = scripter.getPlugin(\"console\");\n  plugin.addSpecialLine(line);\n}");
    }

    public String getType() {
        return "beanshell";
    }

    public String getCode() {
        return this.code;
    }

    public void run(JinEvent jinEvent, String string, Object[][] objectArray) {
        try {
            String string2;
            Object[] objectArray2;
            int n;
            this.bsh.set("event", (Object)jinEvent);
            this.bsh.set("eventSubtype", (Object)string);
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2 = objectArray[n];
                string2 = (String)objectArray2[0];
                Object object = objectArray2[1];
                if (object instanceof Integer) {
                    this.bsh.set(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    this.bsh.set(string2, ((Long)object).longValue());
                    continue;
                }
                if (object instanceof Double) {
                    this.bsh.set(string2, ((Double)object).doubleValue());
                    continue;
                }
                if (object instanceof Float) {
                    this.bsh.set(string2, ((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Boolean) {
                    this.bsh.set(string2, ((Boolean)object).booleanValue());
                    continue;
                }
                this.bsh.set(string2, object);
            }
            this.bsh.eval("runScript();");
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2 = objectArray[n];
                string2 = (String)objectArray2[0];
                this.bsh.unset(string2);
            }
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }

    public Script createCopy() {
        try {
            BeanShellScript beanShellScript = new BeanShellScript(this.scripter, this.getName(), this.getEventType(), this.getEventSubtypes(), this.getCode());
            beanShellScript.setEnabled(this.isEnabled());
            return beanShellScript;
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            throw new IllegalStateException("EvalError while cloning an existing BeanShellScript!!!");
        }
    }
}

