/*
 * Decompiled with CFR 0.152.
 */
package free.freechess;

import free.util.Struct;
import java.util.StringTokenizer;

public class DeltaBoardStruct
extends Struct {
    public DeltaBoardStruct(int n, int n2, String string, String string2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The amount of plies played (" + n2 + ") may not be negative");
        }
        if (string == null) {
            throw new IllegalArgumentException("The move in algebraic format may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The move in Smith-Warren format may not be null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("The time taken to make the move (" + n3 + ") may not be negative");
        }
        this.setIntegerProperty("GameNumber", n);
        this.setIntegerProperty("PliesPlayedCount", n2);
        this.setStringProperty("MoveAlgebraic", string);
        this.setStringProperty("MoveSmith", string2);
        this.setIntegerProperty("TakenTime", n3);
        this.setIntegerProperty("RemainingTime", n4);
    }

    public static DeltaBoardStruct parseDeltaBoardLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.nextToken().equals("<d1>")) {
            throw new IllegalArgumentException("Missing \"<d1>\" identifier");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        return new DeltaBoardStruct(n, n2, string2, string3, n3, n4);
    }

    public int getGameNumber() {
        return this.getIntegerProperty("GameNumber");
    }

    public int getPliesPlayedCount() {
        return this.getIntegerProperty("PliesPlayedCount");
    }

    public String getMoveAlgebraic() {
        return this.getStringProperty("MoveAlgebraic");
    }

    public String getMoveSmith() {
        return this.getStringProperty("MoveSmith");
    }

    public int getTakenTime() {
        return this.getIntegerProperty("TakenTime");
    }

    public int getRemainingTime() {
        return this.getIntegerProperty("RemainingTime");
    }
}

