/*
 * Decompiled with CFR 0.152.
 */
package free.freechess;

import free.util.Struct;
import java.util.StringTokenizer;

public class SeekInfoStruct
extends Struct {
    public static final int UNREGISTERED = 1;
    public static final int COMPUTER = 2;
    public static final int GM = 4;
    public static final int IM = 8;
    public static final int FM = 16;
    public static final int WGM = 32;
    public static final int WIM = 64;
    public static final int WFM = 128;

    public SeekInfoStruct(boolean bl, int n, String string, int n2, int n3, char c, int n4, int n5, boolean bl2, String string2, char c2, int n6, int n7, boolean bl3, boolean bl4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("The game's initial time (" + n4 + ") may not be negative");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("The game's increment (" + n5 + ") may not be negative");
        }
        switch (c2) {
            case '?': 
            case 'B': 
            case 'W': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad color character: " + c2);
            }
        }
        this.setBooleanProperty("CanAcceptSeek", bl);
        this.setIntegerProperty("Index", n);
        this.setStringProperty("Name", string);
        this.setIntegerProperty("Titles", n2);
        this.setIntegerProperty("Rating", n3);
        this.setCharProperty("ProvShow", c);
        this.setIntegerProperty("Time", n4);
        this.setIntegerProperty("Increment", n5);
        this.setBooleanProperty("IsRated", bl2);
        this.setStringProperty("MatchType", string2);
        this.setCharProperty("RequestedColor", c2);
        this.setIntegerProperty("MinRating", n6);
        this.setIntegerProperty("MaxRating", n7);
        this.setBooleanProperty("IsAutomaticAccept", bl3);
        this.setBooleanProperty("IsFormulaUsed", bl4);
    }

    public static SeekInfoStruct parseSeekInfoLine(String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -=");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("<s>")) {
            bl = true;
        } else if (string2.equals("<sn>")) {
            bl = false;
        } else {
            throw new IllegalArgumentException("Missing \"<s>\" or \"<sn>\" identifier");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        SeekInfoStruct.assertToken(stringTokenizer, "w");
        String string3 = stringTokenizer.nextToken();
        SeekInfoStruct.assertToken(stringTokenizer, "ti");
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        SeekInfoStruct.assertToken(stringTokenizer, "rt");
        String string4 = stringTokenizer.nextToken();
        char c = ' ';
        if (!Character.isDigit(string4.charAt(string4.length() - 1))) {
            c = string4.charAt(string4.length() - 1);
            string4 = string4.substring(0, string4.length() - 1);
        }
        int n3 = Integer.parseInt(string4);
        SeekInfoStruct.assertToken(stringTokenizer, "t");
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        SeekInfoStruct.assertToken(stringTokenizer, "i");
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        SeekInfoStruct.assertToken(stringTokenizer, "r");
        boolean bl2 = stringTokenizer.nextToken().equals("r");
        SeekInfoStruct.assertToken(stringTokenizer, "tp");
        String string5 = stringTokenizer.nextToken();
        SeekInfoStruct.assertToken(stringTokenizer, "c");
        char c2 = stringTokenizer.nextToken().charAt(0);
        SeekInfoStruct.assertToken(stringTokenizer, "rr");
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        int n7 = Integer.parseInt(stringTokenizer.nextToken());
        SeekInfoStruct.assertToken(stringTokenizer, "a");
        boolean bl3 = stringTokenizer.nextToken().equals("t");
        SeekInfoStruct.assertToken(stringTokenizer, "f");
        boolean bl4 = stringTokenizer.nextToken().equals("t");
        return new SeekInfoStruct(bl, n, string3, n2, n3, c, n4, n5, bl2, string5, c2, n6, n7, bl3, bl4);
    }

    private static void assertToken(StringTokenizer stringTokenizer, String string) {
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals(string)) {
            throw new IllegalArgumentException("Bad token \"" + string2 + "\", expected \"" + string + "\" instead");
        }
    }

    public boolean canAcceptSeek() {
        return this.getBooleanProperty("CanAcceptSeek");
    }

    public int getSeekIndex() {
        return this.getIntegerProperty("Index");
    }

    public String getSeekerHandle() {
        return this.getStringProperty("Name");
    }

    public int getSeekerTitles() {
        return this.getIntegerProperty("Titles");
    }

    public int getSeekerRating() {
        return this.getIntegerProperty("Rating");
    }

    public char getSeekerProvShow() {
        return this.getCharProperty("ProvShow");
    }

    public int getMatchTime() {
        return this.getIntegerProperty("Time");
    }

    public int getMatchIncrement() {
        return this.getIntegerProperty("Increment");
    }

    public boolean isMatchRated() {
        return this.getBooleanProperty("IsRated");
    }

    public String getMatchType() {
        return this.getStringProperty("MatchType");
    }

    public char getSeekerColor() {
        return this.getCharProperty("RequestedColor");
    }

    public int getOpponentMinRating() {
        return this.getIntegerProperty("MinRating");
    }

    public int getOpponentMaxRating() {
        return this.getIntegerProperty("MaxRating");
    }

    public boolean isAutomaticAccept() {
        return this.getBooleanProperty("IsAutomaticAccept");
    }

    public boolean isFormulaUsed() {
        return this.getBooleanProperty("IsFormulaUsed");
    }
}

