/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.fault.Kibosh;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiboshFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(KiboshFaultWorker.class);
    private final String id;
    private final Kibosh.KiboshFaultSpec spec;
    private final String mountPath;

    public KiboshFaultWorker(String id, Kibosh.KiboshFaultSpec spec, String mountPath) {
        this.id = id;
        this.spec = spec;
        this.mountPath = mountPath;
    }

    @Override
    public void start(Platform platform, AtomicReference<String> status, KafkaFutureImpl<String> errorFuture) throws Exception {
        log.info("Activating {} {}: {}.", new Object[]{this.spec.getClass().getSimpleName(), this.id, this.spec});
        Kibosh.INSTANCE.addFault(this.mountPath, this.spec);
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating {} {}: {}.", new Object[]{this.spec.getClass().getSimpleName(), this.id, this.spec});
        Kibosh.INSTANCE.removeFault(this.mountPath, this.spec);
    }
}

