/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.command.UsageHelper;
import io.airlift.command.UsagePrinter;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class GlobalUsageSummary {
    private final int columnSize;

    public GlobalUsageSummary() {
        this(79);
    }

    public GlobalUsageSummary(int columnSize) {
        Preconditions.checkArgument((columnSize > 0 ? 1 : 0) != 0, (Object)"columnSize must be greater than 0");
        this.columnSize = columnSize;
    }

    public void usage(GlobalMetadata global) {
        StringBuilder stringBuilder = new StringBuilder();
        this.usage(global, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public void usage(GlobalMetadata global, StringBuilder out) {
        this.usage(global, new UsagePrinter(out, this.columnSize));
    }

    public void usage(GlobalMetadata global, UsagePrinter out) {
        ArrayList commandArguments = Lists.newArrayList();
        commandArguments.addAll(Collections2.transform(global.getOptions(), (Function)new Function<OptionMetadata, String>(){

            public String apply(OptionMetadata option) {
                if (option.isHidden()) {
                    return null;
                }
                return UsageHelper.toUsage(option);
            }
        }));
        out.newPrinterWithHangingIndent(8).append("usage:").append(global.getName()).appendWords(commandArguments).append("<command> [<args>]").newline().newline();
        TreeMap commands = Maps.newTreeMap();
        for (CommandMetadata commandMetadata : global.getDefaultGroupCommands()) {
            if (commandMetadata.isHidden()) continue;
            commands.put(commandMetadata.getName(), commandMetadata.getDescription());
        }
        for (CommandGroupMetadata commandGroupMetadata : global.getCommandGroups()) {
            commands.put(commandGroupMetadata.getName(), commandGroupMetadata.getDescription());
        }
        out.append("The most commonly used ").append(global.getName()).append(" commands are:").newline();
        out.newIndentedPrinter(4).appendTable(Iterables.transform(commands.entrySet(), (Function)new Function<Map.Entry<String, String>, Iterable<String>>(){

            public Iterable<String> apply(Map.Entry<String, String> entry) {
                return ImmutableList.of((Object)entry.getKey(), (Object)Objects.firstNonNull((Object)entry.getValue(), (Object)""));
            }
        }));
        out.newline();
        out.append("See").append("'" + global.getName()).append("help <command>' for more information on a specific command.").newline();
    }
}

