/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.authenticator;

import java.io.Serializable;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.tribes.Member;

public class SingleSignOnMessage
implements ClusterMessage,
Serializable {
    public static final int ADD_SESSION = 1;
    public static final int DEREGISTER_SESSION = 2;
    public static final int LOGOUT_SESSION = 3;
    public static final int REGISTER_SESSION = 4;
    public static final int UPDATE_SESSION = 5;
    public static final int REMOVE_SESSION = 6;
    private int action = -1;
    private String ssoId = null;
    private String ctxname = null;
    private String sessionId = null;
    private String authType = null;
    private String password = null;
    private String username = null;
    private SerializablePrincipal principal = null;
    private Member address = null;
    private long timestamp = 0L;
    private String uniqueId = null;

    public SingleSignOnMessage(Member source, String ssoId, String sessionId) {
        this.address = source;
        this.ssoId = ssoId;
        this.sessionId = sessionId;
    }

    public Member getAddress() {
        return this.address;
    }

    public void setAddress(Member member) {
        this.address = member;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getUniqueId() {
        if (this.uniqueId != null) {
            return this.uniqueId;
        }
        StringBuffer result = new StringBuffer(this.getSsoId());
        result.append("#-#");
        result.append(System.currentTimeMillis());
        return result.toString();
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public String getSsoId() {
        return this.ssoId;
    }

    public void setSsoId(String ssoId) {
        this.ssoId = ssoId;
    }

    public String getContextName() {
        return this.ctxname;
    }

    public void setContextName(String ctxname) {
        this.ctxname = ctxname;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SerializablePrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(SerializablePrincipal principal) {
        this.principal = principal;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOnMessage[action=");
        sb.append(this.getAction()).append(", ssoId=").append(this.getSsoId());
        sb.append(", sessionId=").append(this.getSessionId()).append(", username=");
        sb.append(this.getUsername()).append("]");
        return sb.toString();
    }
}

