/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.align;

import edu.umd.marbl.mhap.align.AlignElement;
import edu.umd.marbl.mhap.align.Alignment;
import java.util.ArrayList;
import java.util.Collections;

public final class Aligner<S extends AlignElement<S>> {
    private final float gapOpen;
    private final float gapExtend;
    private final boolean storePath;
    private final float scoreOffset;

    public Aligner(boolean storePath, double gapOpen, double gapExtend, double scoreOffset) {
        this.gapOpen = (float)gapOpen;
        this.gapExtend = (float)gapExtend;
        this.storePath = storePath;
        this.scoreOffset = (float)scoreOffset;
    }

    public Alignment<S> localAlignSmithWaterGotoh(S a, S b) {
        float[][] D = new float[a.length() + 1][b.length() + 1];
        float[][] P = new float[a.length() + 1][b.length() + 1];
        float[][] Q = new float[a.length() + 1][b.length() + 1];
        for (int i = 1; i <= a.length(); ++i) {
            D[i][0] = 0.0f;
            P[i][0] = Float.NEGATIVE_INFINITY;
            Q[i][0] = Float.NEGATIVE_INFINITY;
        }
        for (int j = 1; j <= b.length(); ++j) {
            D[0][j] = 0.0f;
            P[0][j] = Float.NEGATIVE_INFINITY;
            Q[0][j] = Float.NEGATIVE_INFINITY;
        }
        float maxValue = 0.0f;
        int maxI = 0;
        int maxJ = 0;
        for (int i = 1; i <= a.length(); ++i) {
            for (int j = 1; j <= b.length(); ++j) {
                P[i][j] = Math.max(D[i - 1][j] + this.gapOpen, P[i - 1][j] + this.gapExtend);
                Q[i][j] = Math.max(D[i][j - 1] + this.gapOpen, Q[i][j - 1] + this.gapExtend);
                float score = D[i - 1][j - 1] + (float)a.similarityScore(b, i - 1, j - 1) + this.scoreOffset;
                D[i][j] = Math.max(score, Math.max(P[i][j], Q[i][j]));
                if (!(D[i][j] > maxValue)) continue;
                maxValue = D[i][j];
                maxI = i;
                maxJ = j;
            }
        }
        float score = maxValue;
        int a1 = 0;
        int a2 = Math.max(0, maxI - 1);
        int b1 = 0;
        int b2 = Math.max(0, maxJ - 1);
        if (this.storePath) {
            ArrayList<Alignment.Operation> backOperations = new ArrayList<Alignment.Operation>(a.length() + b.length());
            int i = maxI;
            int j = maxJ;
            while (i > 0 && j > 0) {
                if (P[i][j] >= Q[i][j] && P[i][j] == D[i][j] || j == 0) {
                    backOperations.add(Alignment.Operation.DELETE);
                    --i;
                    continue;
                }
                if (Q[i][j] == D[i][j] || i == 0) {
                    backOperations.add(Alignment.Operation.INSERT);
                    --j;
                    continue;
                }
                backOperations.add(Alignment.Operation.MATCH);
                --i;
                --j;
            }
            a1 = i;
            b1 = j;
            while (i > 0) {
                backOperations.add(Alignment.Operation.DELETE);
                --i;
            }
            Collections.reverse(backOperations);
            return new Alignment<S>(a, b, a1, a2, b1, b2, score, this.gapOpen, backOperations);
        }
        return new Alignment<S>(a, b, a1, a2, b1, b2, score, this.gapOpen, null);
    }

    public Alignment<S> localAlignOneSkip(S a, S b) {
        float[][] D = new float[a.length() + 1][b.length() + 1];
        float[][] P = new float[a.length() + 1][b.length() + 1];
        float[][] S = new float[a.length() + 1][b.length() + 1];
        float maxValue = 0.0f;
        int maxI = 0;
        int maxJ = 0;
        for (int i = 1; i <= a.length(); ++i) {
            for (int j = 1; j <= b.length(); ++j) {
                float sim = (float)a.similarityScore(b, i - 1, j - 1) + this.scoreOffset;
                P[i][j] = Math.max(D[i - 1][j] + this.gapOpen, D[i][j - 1] + this.gapOpen);
                D[i][j] = S[i - 1][j - 1] + sim;
                S[i][j] = Math.max(P[i][j], D[i][j]);
                if (i == a.length()) {
                    S[i][j] = Math.max(S[i][j], S[i][j - 1]);
                }
                if (j == b.length()) {
                    S[i][j] = Math.max(S[i][j], S[i - 1][j]);
                }
                if (!(S[i][j] > maxValue) || i != a.length() && j != b.length()) continue;
                maxValue = S[i][j];
                maxI = i;
                maxJ = j;
            }
        }
        float score = maxValue;
        int a1 = 0;
        int a2 = Math.max(0, maxI - 1);
        int b1 = 0;
        int b2 = Math.max(0, maxJ - 1);
        if (this.storePath) {
            ArrayList<Alignment.Operation> backOperations = new ArrayList<Alignment.Operation>(a.length() + b.length());
            int i = maxI;
            int j = maxJ;
            while (i > 0 && j > 0) {
                if (S[i][j] == D[i - 1][j] + this.gapOpen) {
                    backOperations.add(Alignment.Operation.DELETE);
                    --i;
                    continue;
                }
                if (S[i][j] == D[i][j - 1] + this.gapOpen) {
                    backOperations.add(Alignment.Operation.INSERT);
                    --j;
                    continue;
                }
                backOperations.add(Alignment.Operation.MATCH);
                --i;
                --j;
            }
            a1 = i;
            b1 = j;
            while (i > 0) {
                backOperations.add(Alignment.Operation.DELETE);
                --i;
            }
            while (j > 0) {
                backOperations.add(Alignment.Operation.INSERT);
                --j;
            }
            Collections.reverse(backOperations);
            return new Alignment<S>(a, b, a1, a2, b1, b2, score, this.gapOpen, backOperations);
        }
        int i = maxI;
        int j = maxJ;
        while (i > 0 && j > 0) {
            if (S[i - 1][j] > S[i][j - 1] && S[i - 1][j] > S[i - 1][j - 1]) {
                --i;
                continue;
            }
            if (S[i][j - 1] > S[i - 1][j - 1]) {
                --j;
                continue;
            }
            --i;
            --j;
        }
        a1 = i;
        b1 = j;
        return new Alignment<S>(a, b, a1, a2, b1, b2, score, this.gapOpen, null);
    }
}

