/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import org.igoweb.igoweb.client.CChallenge;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.CGameComparator;
import org.igoweb.igoweb.client.CGameContainer;
import org.igoweb.igoweb.client.CGameListEntry;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.APopupMenu;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.SortedListModel;

public abstract class GameList
extends AList<CGameListEntry>
implements EventListener {
    public static final int FLAG_OPEN_GAMES_ONLY = 1;
    public static final int FLAG_SHOW_ROOM_NAME = 2;
    public static final int FLAG_ACTIVE_GAMES_ONLY = 4;
    private static final String OPEN_GAMES_SORT_PREF = "v7Sc6C\\)";
    private final APopupMenu gamePop;
    private final JMenuItem joinGameMI;
    private final JMenuItem sortGamesByNameMI;
    private final JMenuItem sortGamesByRankMI;
    private final JMenuItem sortGamesByObserversMI;
    private final JMenuItem sortGamesByOpenMI;
    private final JCheckBoxMenuItem eventBoxMI;
    private final JCheckBoxMenuItem subscriberBoxMI;
    private final JCheckBoxMenuItem recordedMI;
    private final JMenuItem killGameMI;
    private User me;
    private SortedListModel<CGameListEntry> model;
    private final CGameContainer gameContainer;
    protected final Client client;

    public GameList(CGameContainer gameContainer, Client client, int flags, ListCellRenderer<CGameListEntry> cellRenderer) {
        super(cellRenderer, 2, null, null, false);
        this.gameContainer = gameContainer;
        gameContainer.addListener(this);
        this.client = client;
        int sortFlags = flags & 5;
        CGameComparator gameSorter = new CGameComparator(sortFlags == 0 ? 0 : 3);
        this.model = new SortedListModel<CGameListEntry>(gameSorter);
        this.setListModel(this.model);
        this.addListener(this);
        this.gamePop = new GamePop();
        this.addPopup(this.gamePop);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GameList.this.handleAction(event.getSource());
            }
        };
        this.joinGameMI = new JMenuItem(Defs.getString(-903340708));
        this.gamePop.add(this.joinGameMI);
        this.joinGameMI.addActionListener(actionListener);
        this.gamePop.addSeparator();
        ButtonGroup sorts = new ButtonGroup();
        int sortType = gameSorter.getSortType();
        this.sortGamesByNameMI = new JRadioButtonMenuItem(Defs.getString(-903340595));
        sorts.add(this.sortGamesByNameMI);
        this.sortGamesByNameMI.setSelected(sortType == 1);
        this.sortGamesByNameMI.addActionListener(actionListener);
        this.sortGamesByRankMI = new JRadioButtonMenuItem(Defs.getString(-903340591));
        sorts.add(this.sortGamesByRankMI);
        this.sortGamesByRankMI.setSelected(sortType == 3);
        this.sortGamesByRankMI.addActionListener(actionListener);
        this.sortGamesByOpenMI = new JRadioButtonMenuItem(Defs.getString(-903340653));
        sorts.add(this.sortGamesByOpenMI);
        this.sortGamesByOpenMI.setSelected(sortType == 0);
        this.gamePop.add(this.sortGamesByOpenMI);
        this.sortGamesByOpenMI.addActionListener(actionListener);
        this.sortGamesByOpenMI.setEnabled((flags & 5) == 0);
        this.gamePop.add(this.sortGamesByRankMI);
        this.gamePop.add(this.sortGamesByNameMI);
        this.sortGamesByObserversMI = new JRadioButtonMenuItem(Defs.getString(-903340592));
        sorts.add(this.sortGamesByObserversMI);
        this.sortGamesByObserversMI.setSelected(sortType == 2);
        this.sortGamesByObserversMI.setEnabled((flags & 1) == 0);
        this.gamePop.add(this.sortGamesByObserversMI);
        this.sortGamesByObserversMI.addActionListener(actionListener);
        this.me = client.getMe();
        if (this.me.getAuthLevel() >= 3) {
            this.gamePop.addSeparator();
            this.eventBoxMI = new JCheckBoxMenuItem(Defs.getString(-903340484));
            this.gamePop.add(this.eventBoxMI);
            this.eventBoxMI.addActionListener(actionListener);
        } else {
            this.eventBoxMI = null;
        }
        if (this.me.getAuthLevel() >= 4) {
            this.subscriberBoxMI = new JCheckBoxMenuItem(Defs.getString(-903340483));
            this.gamePop.add(this.subscriberBoxMI);
            this.subscriberBoxMI.addActionListener(actionListener);
            this.gamePop.addSeparator();
            this.recordedMI = new JCheckBoxMenuItem(Defs.getString(-903340673));
            this.gamePop.add(this.recordedMI);
            this.recordedMI.addActionListener(actionListener);
            this.gamePop.addSeparator();
            this.killGameMI = new JMenuItem(Defs.getString(-903340584));
            this.gamePop.add(this.killGameMI);
            this.killGameMI.addActionListener(actionListener);
        } else {
            this.killGameMI = null;
            this.subscriberBoxMI = null;
            this.recordedMI = null;
        }
    }

    private void handleAction(Object src) {
        final CGameListEntry target = (CGameListEntry)this.gamePop.getTarget();
        if (src == this.joinGameMI) {
            this.joinRequested(target);
        } else if (src == this.sortGamesByRankMI) {
            this.setSortType(3);
        } else if (src == this.sortGamesByNameMI) {
            this.setSortType(1);
        } else if (src == this.sortGamesByObserversMI) {
            this.setSortType(2);
        } else if (src == this.sortGamesByOpenMI) {
            this.setSortType(0);
        } else if (src == this.eventBoxMI) {
            target.sendSetEvent(this.eventBoxMI.isSelected());
        } else if (src == this.subscriberBoxMI) {
            target.sendSetSubscribersOnly(this.subscriberBoxMI.isSelected());
        } else if (src == this.recordedMI) {
            target.sendSetRecorded(this.recordedMI.isSelected());
        } else if (src == this.killGameMI) {
            CGameListEntry gameTarget = target;
            new MsgOut(Defs.getString(-903340724), Defs.getString(-903340636, new Object[]{IBundle.get().getGameTypeDescription(gameTarget.gameType), gameTarget.getPlayer((Role)gameTarget.gameType.owner).name}), 3, (Component)this, new String[]{Defs.getString(1436228521), Defs.getString(1436228510)}, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getActionCommand().equals(Defs.getString(1436228521))) {
                        target.sendDeleteRequest();
                    }
                }
            });
        }
    }

    private void setSortType(int sortType) {
        CGameComparator comparator = (CGameComparator)this.model.getComparator();
        comparator.setSortType(sortType);
        this.model.sortNow();
    }

    @Override
    public void handleEvent(Event event) {
        if (event.source == this) {
            this.joinRequested((CChannel)event.arg);
        } else {
            switch (event.type) {
                case 57: {
                    this.doAdd((CGameListEntry)event.arg);
                    break;
                }
                case 58: {
                    this.doRemove((CGameListEntry)event.arg);
                    break;
                }
                case 59: {
                    this.model.changed((CGameListEntry)event.arg);
                    break;
                }
                case 15: {
                    if (event.source == this.gameContainer) break;
                    CGameListEntry chan = (CGameListEntry)event.source;
                    if (this.client.objects.get(new Integer(chan.id)) != this) break;
                    this.client.objects.remove(new Integer(chan.id));
                    if (!(chan instanceof CChallenge)) break;
                    this.buildChalWin((CChallenge)chan);
                    break;
                }
                case 22: {
                    if (event.source == this.gameContainer) break;
                    this.model.remove((CGameListEntry)event.source);
                    break;
                }
                case 38: 
                case 40: {
                    this.doAdd((CGameListEntry)event.source);
                    break;
                }
                case 42: {
                    this.model.changed((CGameListEntry)event.source);
                }
            }
        }
    }

    private void doAdd(CGameListEntry chan) {
        if (this.model.add(chan)) {
            chan.addListener(this);
        }
    }

    private void doRemove(CGameListEntry chan) {
        if (chan == null) {
            return;
        }
        this.model.remove(chan);
        chan.removeListener(this);
        if (this.client.objects.get(new Integer(chan.id)) == this) {
            chan.sendUnjoinRequest();
        }
    }

    private void joinRequested(CChannel chan) {
        CGame game;
        if (this.me.getAuthLevel() >= 4 && chan instanceof CGame && (game = (CGame)chan).isPrivate() && !game.gameType.isMainRole(game.getRole())) {
            new MsgOut(Defs.getString(-903340724), Defs.getString(-903340468), 3, null, new String[]{Defs.getString(1436228521), Defs.getString(1436228510)}, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getActionCommand().equals(Defs.getString(1436228521))) {
                        GameList.this.doJoin(game);
                    }
                }
            });
            return;
        }
        this.doJoin(chan);
    }

    private void doJoin(final CChannel chan) {
        if (chan.isJoined()) {
            chan.rejoin();
            return;
        }
        if (!chan.isClosed()) {
            chan.addListener(this);
            this.client.objects.put(new Integer(chan.id), this);
            chan.sendJoinRequest();
            this.client.sendSync(new Runnable(){

                @Override
                public void run() {
                    GameList.this.client.objects.remove(new Integer(chan.id));
                }
            });
        }
    }

    private void menuOpened(CGameListEntry target) {
        boolean hasGame = target != null;
        this.joinGameMI.setEnabled(hasGame);
        if (this.killGameMI != null) {
            this.killGameMI.setEnabled(hasGame);
        }
        boolean bl = hasGame = hasGame && target instanceof CGame;
        if (this.eventBoxMI != null) {
            this.eventBoxMI.setEnabled(hasGame);
            if (hasGame) {
                this.eventBoxMI.setSelected(target.isEvent());
            }
        }
        if (this.subscriberBoxMI != null) {
            this.subscriberBoxMI.setEnabled(hasGame);
            this.recordedMI.setEnabled(hasGame);
            if (hasGame) {
                this.subscriberBoxMI.setSelected(target.isSubscribersOnly());
                this.recordedMI.setSelected(target.isRecorded());
            }
        }
    }

    protected abstract void buildChalWin(CChallenge<?> var1);

    @Override
    public void addNotify() {
        this.gameContainer.addListener(this);
        Iterator iter = this.gameContainer.getGames().values().iterator();
        while (iter.hasNext()) {
            this.doAdd((CGameListEntry)iter.next());
        }
        this.model.sortNow();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.gameContainer.removeListener(this);
        Iterator iter = this.model.iterator();
        while (iter.hasNext()) {
            this.doRemove((CGameListEntry)iter.next());
        }
        super.removeNotify();
    }

    private class GamePop
    extends APopupMenu {
        public GamePop() {
            super(Defs.getString(-903340726));
        }

        @Override
        public void show(Component comp, int x, int y, Object target) {
            GameList.this.menuOpened((CGameListEntry)target);
            super.show(comp, x, y, target);
        }
    }
}

