/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions.scheme;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.StatisticsDevKitUtil;
import com.intellij.internal.statistic.actions.scheme.EditEventsTestSchemePanel;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.events.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "loadEventsScheme", "Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeStorage", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;", "update", "Companion", "EventsTestScheme", "intellij.platform.statistics.devkit"})
public final class EditEventsTestSchemeAction
extends DumbAwareAction {
    private final String recorderId;
    private static final LayeredIcon ICON;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ValidationTestRulesPersistedStorage testSchemeStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        if (testSchemeStorage == null) {
            String string = StatisticsBundle.message((String)"stats.cannot.find.test.scheme.storage", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message\u2026ind.test.scheme.storage\")");
            StatisticsDevKitUtil.INSTANCE.showNotification(project2, NotificationType.ERROR, string);
            return;
        }
        EventsTestScheme eventsTestScheme = this.loadEventsScheme(project2, testSchemeStorage);
        if (eventsTestScheme == null) {
            return;
        }
        EventsTestScheme scheme = eventsTestScheme;
        EditEventsTestSchemePanel editTestSchemePanel = new EditEventsTestSchemePanel(project2, scheme.getTestScheme(), scheme.getProductionGroups(), scheme.getGeneratedScheme());
        String string = StatisticsBundle.message((String)"stats.edit.test.scheme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message(\"stats.edit.test.scheme\")");
        DialogWrapper dialog2 = ComponentsKt.dialog$default((String)string, (JComponent)editTestSchemePanel, (boolean)true, (JComponent)editTestSchemePanel.getFocusedComponent(), (boolean)false, (Project)project2, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(editTestSchemePanel){
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel;

            @Nullable
            public final List<ValidationInfo> invoke() {
                return this.$editTestSchemePanel.validateGroups();
            }
            {
                this.$editTestSchemePanel = editEventsTestSchemePanel;
                super(0);
            }
        }), (int)976, null);
        Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)editTestSchemePanel);
        if (!dialog2.showAndGet()) {
            return;
        }
        String string2 = StatisticsBundle.message((String)"stats.updating.test.scheme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StatisticsBundle.message\u2026ts.updating.test.scheme\")");
        String string3 = string2;
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, (String)title$iv, cancellable$iv, testSchemeStorage, editTestSchemePanel, project2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage$inlined;
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$testSchemeStorage$inlined = validationTestRulesPersistedStorage;
                this.$editTestSchemePanel$inlined = editEventsTestSchemePanel;
                this.$project$inlined = project;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                try {
                    this.$testSchemeStorage$inlined.updateTestGroups(this.$editTestSchemePanel$inlined.getGroups());
                    String string = StatisticsBundle.message((String)"stats.test.scheme.was.updated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message\u2026test.scheme.was.updated\")");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.INFORMATION, string);
                }
                catch (IOException ex) {
                    String string = StatisticsBundle.message((String)"stats.failed.updating.test.scheme.0", (Object[])new Object[]{ex.getMessage()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StatisticsBundle.message\u2026st.scheme.0\", ex.message)");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, string);
                }
            }
        });
    }

    private final EventsTestScheme loadEventsScheme(Project project, ValidationTestRulesPersistedStorage testSchemeStorage) {
        return (EventsTestScheme)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<EventsTestScheme, IOException>(testSchemeStorage, project, project, StatisticsBundle.message((String)"stats.loading.test.scheme", (Object[])new Object[0]), true){
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage;
            final /* synthetic */ Project $project;

            @Nullable
            protected EventsTestScheme compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                List list = this.$testSchemeStorage.loadValidationTestRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"testSchemeStorage.loadValidationTestRules()");
                List localGroups = list;
                if (indicator.isCanceled()) {
                    return null;
                }
                EventGroupRemoteDescriptors eventGroupRemoteDescriptors = this.$testSchemeStorage.loadProductionGroups();
                Intrinsics.checkNotNullExpressionValue((Object)eventGroupRemoteDescriptors, (String)"testSchemeStorage.loadProductionGroups()");
                EventGroupRemoteDescriptors productionGroups = eventGroupRemoteDescriptors;
                if (indicator.isCanceled()) {
                    return null;
                }
                List eventsScheme = EventsSchemeBuilder.buildEventsScheme();
                return new EventsTestScheme(localGroups, productionGroups, eventsScheme);
            }
            {
                this.$testSchemeStorage = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
        ValidationTestRulesPersistedStorage validationTestRulesPersistedStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        int testSchemeSize = validationTestRulesPersistedStorage != null ? validationTestRulesPersistedStorage.size() : 0;
        String text = testSchemeSize < 100 ? String.valueOf(testSchemeSize) : "99+";
        TextIcon sizeCountIcon = new TextIcon(text, (Color)JBColor.DARK_GRAY, UIUtil.getLabelBackground(), 1);
        Font font = UIUtil.getLabelFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIUtil.getLabelFont()");
        sizeCountIcon.setFont(new Font(font.getName(), 1, JBUIScale.scale((int)9)));
        sizeCountIcon.setInsets(1, 1, 0, 0);
        ICON.setIcon((Icon)sizeCountIcon, 1, JBUIScale.scale((int)10), JBUIScale.scale((int)10));
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setIcon((Icon)ICON);
    }

    public EditEventsTestSchemeAction(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.description", (Object[])new Object[0]), (Icon)ICON);
        this.recorderId = recorderId;
    }

    public /* synthetic */ EditEventsTestSchemeAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public EditEventsTestSchemeAction() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        ICON = new LayeredIcon(2);
        ICON.setIcon(AllIcons.Actions.Edit, 0);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "", "testScheme", "", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "productionGroups", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupRemoteDescriptors;", "generatedScheme", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "(Ljava/util/List;Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupRemoteDescriptors;Ljava/util/List;)V", "getGeneratedScheme", "()Ljava/util/List;", "getProductionGroups", "()Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupRemoteDescriptors;", "getTestScheme", "intellij.platform.statistics.devkit"})
    public static final class EventsTestScheme {
        @NotNull
        private final List<GroupValidationTestRule> testScheme;
        @NotNull
        private final EventGroupRemoteDescriptors productionGroups;
        @NotNull
        private final List<EventsSchemeBuilder.GroupDescriptor> generatedScheme;

        @NotNull
        public final List<GroupValidationTestRule> getTestScheme() {
            return this.testScheme;
        }

        @NotNull
        public final EventGroupRemoteDescriptors getProductionGroups() {
            return this.productionGroups;
        }

        @NotNull
        public final List<EventsSchemeBuilder.GroupDescriptor> getGeneratedScheme() {
            return this.generatedScheme;
        }

        public EventsTestScheme(@NotNull List<GroupValidationTestRule> testScheme, @NotNull EventGroupRemoteDescriptors productionGroups, @NotNull List<EventsSchemeBuilder.GroupDescriptor> generatedScheme) {
            Intrinsics.checkNotNullParameter(testScheme, (String)"testScheme");
            Intrinsics.checkNotNullParameter((Object)productionGroups, (String)"productionGroups");
            Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
            this.testScheme = testScheme;
            this.productionGroups = productionGroups;
            this.generatedScheme = generatedScheme;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/actions/scheme/EditEventsTestSchemeAction$Companion;", "", "()V", "ICON", "Lcom/intellij/ui/LayeredIcon;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

