/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.CommentQueryGenerator;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlActions {
    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e) {
        DbTable tableElement;
        Set columns = DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class).toSet();
        Set tables = ContainerUtil.map2Set((Collection)columns, (Function)((NullableFunction)element2 -> element2.getParent()));
        DbTable dbTable = tableElement = tables.size() == 1 ? (DbTable)tables.iterator().next() : null;
        if (tableElement == null) {
            @NotNull DataContext dataContext = e.getDataContext();
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
            DbElement element3 = (DbElement)selection.single();
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element3, DbTable.class, (boolean)false);
            columns = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, (Object)columns);
        if (pair == null) {
            DdlActions.$$$reportNull$$$0(0);
        }
        return pair;
    }

    public static boolean isDbViewToolbar(@Nullable AnActionEvent e) {
        return e != null && e.getPlace().equals(ActionPlaces.getActionGroupPopupPlace((String)"DatabaseViewToolbar"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions", "getTableAndColumns"));
    }

    public static class CommentOnObjectAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement single;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(0);
            }
            BasicNamedElement element2 = (single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel model = element2 == null ? null : element2.getModel();
            boolean visible = model != null && CommentQueryGenerator.canComment(model, element2) && DbImplUtilCore.canConnectTo(single);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(single));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BasicModel model;
            JBIterable<DbElement> selection;
            DbElement single;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(1);
            }
            final BasicNamedElement element2 = (single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel basicModel = model = element2 == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObjectForSwitch(single.getDataSource(), element2), BasicNamespace.class);
            final CommentQueryGenerator generator = new CommentQueryGenerator(single.getProject(), model, element2);
            generator.setCurrentNamespace(current);
            new DatabaseScriptDialog(single.getProject(), single.getDataSource(), ObjectPaths.searchPathOf(current), DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.title", new Object[0])){
                private FieldPanel myComment;

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.regenerate();
                }

                @Override
                protected JComponent createCenterPanel() {
                    this.myComment = new FieldPanel(DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.comment", new Object[0]), null, null, () -> this.regenerate());
                    this.myComment.setText(element2.getComment());
                    return new BorderLayoutPanel().addToTop((Component)this.myComment).addToCenter((Component)Objects.requireNonNull(super.createCenterPanel()));
                }

                private void regenerate() {
                    this.generateText(this.myComment.getText());
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return this.myComment.getTextField();
                }

                private void generateText(String comment) {
                    this.updateText(generator.generate(comment));
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                    if (handler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    handler.getContext().include(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/DdlActions$CommentOnObjectAction$1", "fillContext"));
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        public DropForeignKeyAction() {
            super(DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbColumn> selection;
            DbColumn column2;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            boolean visible = (column2 = (DbColumn)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class)).single()) != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(column2)).getDbEditorCaps().getTableEditorCaps(true).getForeignKeys().canRemove() && DbImplUtilCore.canConnectTo(column2) && DasUtil.isForeign(column2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(column2));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbColumn column2;
            DbTable table;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            DbTable dbTable = table = (column2 = (DbColumn)DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class).first()) == null ? null : column2.getTable();
            if (table == null) {
                return;
            }
            DbDataSource dataSource2 = column2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(column2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource2.getProject(), model);
            JBIterable selection = JBIterable.from(DasUtil.getForeignKeys(table)).filter(key -> DasUtil.containsName(column2.getName(), key.getColumnsRef())).filter(DbElement.class);
            generator.setItems((Iterable<BasicElement>)DbDeleteProvider.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        public DropPrimaryKeyAction() {
            super(DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement element2;
            DbTable tableElement;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            boolean visible = (tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single()), DbTable.class, (boolean)false)) != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(tableElement)).getDbEditorCaps().getTableEditorCaps(true).getPrimaryKey().canRemove() && DbImplUtilCore.canConnectTo(tableElement) && DasUtil.getPrimaryKey(tableElement) != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(tableElement));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbTable table;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseContextFun.getSelectedDbElements(e.getDataContext()).first()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey(table);
            if (pk == null) {
                return;
            }
            DbDataSource dataSource2 = pk.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(pk)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource2.getProject(), model);
            JBIterable selection = JBIterable.of((Object)pk);
            generator.setItems((Iterable<BasicElement>)DbDeleteProvider.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        public AddForeignKeyAction() {
            super(DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(0);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        public AddPrimaryKeyAction() {
            super(DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DasUtil.getPrimaryKey((DasTable)pair.first) == null && DbRefactoringDialogHelper.canAddPrimaryKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        public BatchAddIndicesAction() {
            super(DatabaseIcons.Index);
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(0);
            }
            Set columns = DatabaseContextFun.getSelectedDbElements(e.getDataContext(), DbColumn.class).toSet();
            DbDataSource dataSource2 = null;
            for (DbColumn column2 : columns) {
                if (dataSource2 == null) {
                    dataSource2 = column2.getDataSource();
                }
                if (dataSource2 == column2.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    BatchAddIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            return new ArrayList<DbColumn>(columns);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(2);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List<DbColumn> columns = BatchAddIndicesAction.getColumns(e);
            boolean visible = columns.size() > 1 && DbImplUtilCore.canConnectTo(columns.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext(columns.get(0), null), columns);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(columns.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbColumn> columns;
            List basicColumns;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(3);
            }
            if ((basicColumns = JBIterable.from(columns = BatchAddIndicesAction.getColumns(e)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toList()).size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext(columns.get(0), null), basicColumns).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        public AddIndexAction() {
            super(DatabaseIcons.Index);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(0);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && !DbImplUtilCore.getDbms((DbElement)pair.first).isMongo();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddIndexAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        public AddColumnAction() {
            super(DatabaseIcons.Col);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(0);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            @NotNull DataContext dataContext = e.getDataContext();
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
            DbElement element2 = (DbElement)selection.single();
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            boolean visible = table != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(table)).getDbEditorCaps().getTableEditorCaps(true).getColumns().canAdd() && DbImplUtilCore.canConnectTo(table) && DbRefactoringDialogHelper.canAddColumn(new DatabaseEditorContext(table, null), table) && table.getKind() == ObjectKind.TABLE;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(table));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataContext dataContext;
            DbElement element2;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext = e.getDataContext()).single()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            AddColumnAction.perform(table, (DbColumn)PsiTreeUtil.getParentOfType((PsiElement)element2, DbColumn.class, (boolean)false), "new_column");
        }

        public static void perform(@NotNull DbTable table, @Nullable DbColumn anchor2, @NotNull String colName) {
            BasicTable basicTable;
            if (table == null) {
                AddColumnAction.$$$reportNull$$$0(2);
            }
            if (colName == null) {
                AddColumnAction.$$$reportNull$$$0(3);
            }
            if ((basicTable = (BasicTable)ObjectUtils.tryCast((Object)table.getDelegate(), BasicTable.class)) == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                List<DeColumn> columns = ((DatabaseTableEditor)dialog2.getEditor()).getTable().columns;
                int idx = columns.size();
                if (anchor2 != null && ((DatabaseTableEditor)dialog2.getEditor()).getCaps().getColumns().canReorder()) {
                    String name = anchor2.getName();
                    idx = 0;
                    for (DeColumn column2 : columns) {
                        ++idx;
                        if (!column2.name.equals(name)) continue;
                        break;
                    }
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol, idx)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(0);
            }
            @NotNull DataContext dataContext = e.getDataContext();
            JBIterable elements = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext).filter(DbIndex.class);
            DbDataSource dataSource2 = null;
            for (DbIndex element2 : elements) {
                DbDataSource currentSource = element2.getDataSource();
                if (dataSource2 == null) {
                    dataSource2 = currentSource;
                }
                if (dataSource2 == currentSource) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    BatchModifyIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = elements.toList();
            if (list == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() > 1 && DbImplUtilCore.canConnectTo(indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext(indices.get(0), null), indices);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(indices.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(4);
            }
            if ((indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(5);
            }
            List basicIndices = JBIterable.from(indices).transform(DbElement::getDelegate).filter(BasicIndex.class).toList();
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext(indices.get(0), null), basicIndices).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicesToModify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndicesToModify";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showModifyIndicesDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        public AddTableAction() {
            super(DatabaseIcons.Table);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(0);
            }
            if (DdlActions.isDbViewToolbar(e)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            DbElement element2 = AddTableAction.getElement(e);
            DbElement parent2 = (DbElement)((Object)DbImplUtil.getTopSingleNamespace(element2));
            boolean visible = parent2 != null && parent2.getKind() == ObjectKind.SCHEMA && (DbImplUtilCore.canConnectTo(parent2) || DbImplUtilCore.isDdlElement(element2)) && !DbImplUtilCore.getDbms(element2).isMongo();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && ImportUtil.canModify(parent2) && AddTableAction.canDoAnything(element2));
        }

        private static boolean canDoAnything(DbElement element2) {
            return SchemaEditor.forDbms(DbImplUtilCore.getDbms(element2)).getDbEditorCaps().getTableEditorCaps(false).canDoAnything();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(1);
            }
            if ((element2 = AddTableAction.getElement(e)) == null) {
                return;
            }
            DasNamespace namespace = DbImplUtil.getTopSingleNamespace(element2);
            Pair<BasicElement, DatabaseEditorContext> info = DatabaseObjectRefactoring.prepareForEditing((DbNamespaceImpl)namespace, namespace);
            if (info == null || !(info.first instanceof BasicSchema)) {
                return;
            }
            AddTableAction.showAddTableDialogAndRun((BasicSchema)info.first, (DatabaseEditorContext)info.second, "table_name", ContainerUtil.emptyList());
        }

        @Nullable
        private static DbElement getElement(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(2);
            }
            @NotNull DataContext dataContext = e.getDataContext();
            return (DbElement)DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).first();
        }

        public static void showAddTableDialogAndRun(@Nullable BasicSchema schema, @Nullable DatabaseEditorContext context, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (defaultName == null) {
                AddTableAction.$$$reportNull$$$0(3);
            }
            if (columnNames == null) {
                AddTableAction.$$$reportNull$$$0(4);
            }
            if (context != null) {
                DbRefactoringDialogHelper.newAddTableDialog(context, schema, defaultName, columnNames).finishAndShow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddTableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAddTableDialogAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

