/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.extensions.SchemaLayoutScripts;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a0\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001aP\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r26\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000f\u001aD\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u001a \u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0003\u001a,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f\u001a$\u0010'\u001a\u0016\u0012\u0004\u0012\u00020)\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020*0\u00020(2\u0006\u0010+\u001a\u00020,H\u0002\u001a\u001c\u0010-\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a4\u0010.\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001500H\u0002\u001a&\u00101\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u001a&\u00102\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a8\u00063"}, d2={"computeFileListChanges", "Lcom/intellij/openapi/util/Couple;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "Ljava/io/File;", "allFiles", "createScriptConsumer", "Lcom/intellij/database/script/generator/ScriptedScriptConsumer;", "project", "Lcom/intellij/openapi/project/Project;", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "writer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "s", "Lcom/intellij/database/script/generator/ScriptingResult;", "t", "", "dump", "model", "Lcom/intellij/database/model/basic/BasicModel;", "scope", "Lcom/intellij/database/util/TreePattern;", "be", "", "Lcom/intellij/database/model/basic/BasicElement;", "dropExtra", "", "fileListMsg", "", "extra", "output", "generate", "task", "Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "getElementsByDs", "", "Lcom/intellij/database/model/DasDataSource;", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectFile", "setUp", "fileConsumer", "Lkotlin/Function1;", "suggestAddingPaths", "suggestDeletingFiles", "intellij.database.impl"})
public final class DumpToDdlDataSourceActionKt {
    private static final boolean setUp(Project project, SqlDataSource sqlDs2, ScriptingTaskBuilder task2, Function1<? super File, Unit> fileConsumer) {
        ScriptedScriptConsumer scriptedScriptConsumer = DumpToDdlDataSourceActionKt.createScriptConsumer(project, sqlDs2, (Function2<? super File, ? super ScriptingResult, Unit>)((Function2)new Function2<File, ScriptingResult, Unit>(fileConsumer){
            final /* synthetic */ Function1 $fileConsumer;

            public final void invoke(@NotNull File file, @NotNull ScriptingResult txt) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
                String text2 = txt.getScriptText();
                CharSequence charSequence = text2;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    FileUtil.writeToFile((File)file, (String)text2);
                    this.$fileConsumer.invoke((Object)file);
                }
            }
            {
                this.$fileConsumer = function1;
                super(2);
            }
        }));
        if (scriptedScriptConsumer == null) {
            return false;
        }
        ScriptedScriptConsumer consumer2 = scriptedScriptConsumer;
        Map map2 = sqlDs2.getScriptOptions();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"sqlDs.scriptOptions");
        task2.setOptions(ScriptingOptionStatic.importScriptingOptions(map2));
        task2.setCodeStyle(ScriptingTaskBuilderKt.getSqlCodeStyle(project, sqlDs2));
        task2.setConsumer(consumer2);
        return true;
    }

    @Nullable
    public static final ScriptedScriptConsumer createScriptConsumer(@NotNull Project project, @NotNull SqlDataSource sqlDs2, @NotNull Function2<? super File, ? super ScriptingResult, Unit> writer) {
        File outPath;
        File file;
        Function2<? super File, ? super ScriptingResult, Unit> function2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        File script = SchemaLayoutScripts.findScript(sqlDs2.getOutputLayout());
        if (script == null) {
            return null;
        }
        Function2<? super File, ? super ScriptingResult, Unit> function22 = sqlDs2.getOutputPath();
        if (function22 != null) {
            function2 = function22;
            boolean bl = false;
            boolean bl2 = false;
            Function2<? super File, ? super ScriptingResult, Unit> it2 = function2;
            boolean bl3 = false;
            file = new File((String)it2);
        } else {
            file = outPath = null;
        }
        if (outPath == null) {
            return null;
        }
        function2 = writer;
        return ScriptedScriptConsumer.createScriptedConsumer(project, script, outPath, (PairConsumer<File, ScriptingResult>)new PairConsumer(function2){
            private final /* synthetic */ Function2 function;
            {
                this.function = function2;
            }

            public final /* synthetic */ void consume(Object p0, Object p1) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0, p1), (String)"invoke(...)");
            }
        });
    }

    @NotNull
    public static final Set<File> generate(@NotNull Project project, @NotNull SqlDataSource sqlDs2, @NotNull ScriptingTaskBuilder task2, boolean dropExtra) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        LinkedHashSet generated = new LinkedHashSet();
        new Task.Modal(project, sqlDs2, task2, generated, dropExtra, project, DatabaseBundle.message("dialog.title.generating", new Object[0]), true){
            final /* synthetic */ Project $project;
            final /* synthetic */ SqlDataSource $sqlDs;
            final /* synthetic */ ScriptingTaskBuilder $task;
            final /* synthetic */ LinkedHashSet $generated;
            final /* synthetic */ boolean $dropExtra;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(this){
                    final /* synthetic */ generate.1 this$0;

                    public final void run() {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        if (!DumpToDdlDataSourceActionKt.access$setUp(this.this$0.$project, this.this$0.$sqlDs, this.this$0.$task, (Function1)new Function1<File, Unit>(this.this$0.$generated){

                            public final void invoke(@NotNull File p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                ((LinkedHashSet)this.receiver).add(p1);
                            }
                        })) {
                            return;
                        }
                        HashSet<E> all = new HashSet<E>();
                        for (VirtualFile root2 : this.this$0.$sqlDs.getRoots()) {
                            VfsUtil.visitChildrenRecursively((VirtualFile)root2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(all, new VirtualFileVisitor.Option[0]){
                                final /* synthetic */ HashSet $all;

                                public boolean visitFile(@NotNull VirtualFile file) {
                                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                    return this.$all.add(file);
                                }
                                {
                                    this.$all = $captured_local_variable$0;
                                    super($super_call_param$1);
                                }
                            }));
                        }
                        ScriptGenerators.INSTANCE.makeScript(this.this$0.$project, this.this$0.$task.build());
                        List list = this.this$0.$sqlDs.getRoots();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlDs.roots");
                        Collection $this$toTypedArray$iv = list;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
                        if (virtualFileArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
                        ApplicationManager.getApplication().invokeLater(new Runnable(this, all){
                            final /* synthetic */ generate.run.1 this$0;
                            final /* synthetic */ HashSet $all;

                            public final void run() {
                                Couple changes = DumpToDdlDataSourceActionKt.access$computeFileListChanges(this.this$0.this$0.$generated, this.$all);
                                Object object = changes.first;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"changes.first");
                                Collection collection = (Collection)object;
                                boolean bl = false;
                                if (!collection.isEmpty()) {
                                    Project project = this.this$0.this$0.$project;
                                    SqlDataSource sqlDataSource = this.this$0.this$0.$sqlDs;
                                    Object object2 = changes.first;
                                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"changes.first");
                                    DumpToDdlDataSourceActionKt.access$suggestAddingPaths(project, sqlDataSource, (List)object2);
                                }
                                Object object3 = changes.second;
                                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"changes.second");
                                collection = (Collection)object3;
                                bl = false;
                                if (!collection.isEmpty() && this.this$0.this$0.$dropExtra) {
                                    Project project = this.this$0.this$0.$project;
                                    SqlDataSource sqlDataSource = this.this$0.this$0.$sqlDs;
                                    Object object4 = changes.second;
                                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"changes.second");
                                    DumpToDdlDataSourceActionKt.access$suggestDeletingFiles(project, sqlDataSource, (List)object4);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$all = hashSet;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = $captured_local_variable$0;
                this.$sqlDs = $captured_local_variable$1;
                this.$task = $captured_local_variable$2;
                this.$generated = $captured_local_variable$3;
                this.$dropExtra = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        }.queue();
        return generated;
    }

    /*
     * WARNING - void declaration
     */
    private static final void suggestAddingPaths(Project project, SqlDataSource sqlDs2, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        String it2;
        String string = sqlDs2.getOutputPath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            it2 = string2;
            boolean bl3 = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it2);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        int res2 = Messages.showDialog((Project)project, (String)(DatabaseBundle.message("dialog.message.add.new.files.to.sql.data.source", new Object[0]) + DumpToDdlDataSourceActionKt.fileListMsg(extra, output)), (String)DatabaseBundle.message("dialog.title.new.files.produced", new Object[0]), (String[])new String[]{Messages.getYesButton(), DatabaseBundle.message("add.output.folder", new Object[0]), Messages.getNoButton()}, (int)0, null);
        switch (res2) {
            case 0: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = sqlDs2.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlDs.urls");
                Iterable iterable = extra;
                Collection collection2 = list;
                SqlDataSource sqlDataSource = sqlDs2;
                boolean $i$f$map = false;
                it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it3.getUrl();
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                sqlDataSource.setUrls(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                break;
            }
            case 1: {
                VirtualFile virtualFile3 = output;
                if (virtualFile3 == null) {
                    return;
                }
                VirtualFile file = virtualFile3;
                List list = sqlDs2.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlDs.urls");
                sqlDs2.setUrls(CollectionsKt.plus((Collection)list, (Object)file.getUrl()));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void suggestDeletingFiles(Project project, SqlDataSource sqlDs2, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        String it2;
        String string = sqlDs2.getOutputPath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            it2 = string2;
            boolean bl3 = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it2);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        int res2 = Messages.showDialog((Project)project, (String)DatabaseBundle.message("dialog.message.existing.files.haven.t.been.mentioned.during.code.generation.delete.them", DumpToDdlDataSourceActionKt.fileListMsg(extra, output)), (String)DatabaseBundle.message("dialog.title.outdated.files", new Object[0]), (String[])new String[]{Messages.getYesButton(), Messages.getNoButton()}, (int)0, null);
        switch (res2) {
            case 0: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = sqlDs2.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sqlDs.urls");
                Iterable iterable = extra;
                Iterable iterable2 = list;
                SqlDataSource sqlDataSource = sqlDs2;
                boolean $i$f$map = false;
                it2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it3.getUrl();
                    collection.add(string3);
                }
                collection = (List)destination$iv$iv;
                sqlDataSource.setUrls(CollectionsKt.minus((Iterable)iterable2, (Iterable)collection));
                WriteAction.run((ThrowableRunnable)new ThrowableRunnable(extra, sqlDs2){
                    final /* synthetic */ List $extra;
                    final /* synthetic */ SqlDataSource $sqlDs;

                    public final void run() {
                        for (VirtualFile file : this.$extra) {
                            file.delete((Object)this.$sqlDs);
                        }
                    }
                    {
                        this.$extra = list;
                        this.$sqlDs = sqlDataSource;
                    }
                });
                break;
            }
        }
    }

    @Nls
    private static final String fileListMsg(List<? extends VirtualFile> extra, VirtualFile output) {
        int limit = 3;
        List<? extends VirtualFile> list = extra.size() <= limit ? extra : extra.subList(0, limit);
        String files2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<VirtualFile, CharSequence>(output){
            final /* synthetic */ VirtualFile $output;

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final CharSequence invoke(@NotNull VirtualFile it2) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Object object = this.$output;
                if (object != null) {
                    VirtualFile virtualFile = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile p2 = virtualFile;
                    boolean bl3 = false;
                    object = VfsUtil.findRelativePath((VirtualFile)p2, (VirtualFile)it2, (char)File.separatorChar);
                    if (object != null) {
                        charSequence = (CharSequence)object;
                        return charSequence;
                    }
                }
                String string = it2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                charSequence = string;
                return charSequence;
            }
            {
                this.$output = virtualFile;
                super(1);
            }
        }), (int)30, null);
        String more = extra.size() <= limit ? "" : "\n" + DatabaseBundle.message("and.0.files.more", extra.size() - limit);
        return '\n' + files2 + more;
    }

    private static final Couple<List<VirtualFile>> computeFileListChanges(Set<? extends File> files2, Set<? extends VirtualFile> allFiles) {
        ArrayList extra = new ArrayList();
        ArrayList deleted = new ArrayList();
        LinkedHashSet generated = new LinkedHashSet();
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable(files2, generated){
            final /* synthetic */ Set $files;
            final /* synthetic */ LinkedHashSet $generated;

            public final void run() {
                for (File file : this.$files) {
                    VirtualFile vfile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                    if (vfile == null) continue;
                    this.$generated.add(vfile);
                }
            }
            {
                this.$files = set;
                this.$generated = linkedHashSet;
            }
        });
        for (VirtualFile virtualFile : allFiles) {
            if (virtualFile.isDirectory() || generated.contains(virtualFile)) continue;
            Collection collection = deleted;
            boolean bl = false;
            collection.add(virtualFile);
        }
        for (VirtualFile virtualFile : generated) {
            boolean inDs2;
            boolean bl;
            block3: {
                Sequence $this$any$iv = SequencesKt.generateSequence((Object)virtualFile, (Function1)computeFileListChanges.inDs.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it2 = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!allFiles.contains(it2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (inDs2 = bl) continue;
            Collection collection = extra;
            boolean bl2 = false;
            collection.add(virtualFile);
        }
        Couple couple = Couple.of(extra, deleted);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"Couple.of(extra, deleted)");
        return couple;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<DasDataSource, ? extends List<DbElement>> getElementsByDs(AnActionEvent e) {
        void var2_2;
        void $this$groupByTo$iv;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        Iterable iterable = (Iterable)DatabaseContextFun.getSelectedDbElements(dataContext);
        Map destination$iv = new HashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            DbElement it2 = (DbElement)element$iv;
            boolean bl = false;
            DbElement dbElement = it2;
            Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"it");
            DbDataSource dbDataSource = dbElement.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"it.dataSource");
            DatabaseSystem key$iv = dbDataSource.getDelegate();
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        return var2_2;
    }

    @NotNull
    public static final Set<File> dump(@NotNull Project project, @NotNull SqlDataSource sqlDs2, @NotNull BasicModel model, @Nullable TreePattern scope, @NotNull Iterable<? extends BasicElement> be, boolean dropExtra) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sqlDs2, (String)"sqlDs");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(be, (String)"be");
        ScriptingSingleModelTaskBuilder scriptingSingleModelTaskBuilder = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_COMPLETE);
        boolean bl = false;
        boolean bl2 = false;
        ScriptingSingleModelTaskBuilder $this$apply = scriptingSingleModelTaskBuilder;
        boolean bl3 = false;
        ((JBTreeTraverser)DbImplUtil.traverseVisibleObjects((JBTreeTraverser)model.basicTraverser().withRoots(be), scope).filter((Condition)dump.task.1.1.INSTANCE)).bfsTraversal().addAllTo($this$apply.getElements());
        ScriptingSingleModelTaskBuilder task2 = scriptingSingleModelTaskBuilder;
        return DumpToDdlDataSourceActionKt.generate(project, sqlDs2, task2, dropExtra);
    }

    public static final void selectFile(@NotNull Project project, @NotNull Set<? extends File> files2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            File file = (File)CollectionsKt.firstOrNull((Iterable)files2);
            if (file == null) break block1;
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it2 = file2;
            boolean bl3 = false;
            file = (VirtualFile)WriteAction.compute((ThrowableComputable)new ThrowableComputable(it2){
                final /* synthetic */ File $it;

                public final VirtualFile compute() {
                    return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.$it);
                }
                {
                    this.$it = file;
                }
            });
            if (file != null) {
                file2 = file;
                bl = false;
                bl2 = false;
                it2 = file2;
                boolean bl4 = false;
                new OpenFileDescriptor(project, (VirtualFile)it2).navigate(true);
            }
        }
    }

    public static final /* synthetic */ Map access$getElementsByDs(AnActionEvent e) {
        return DumpToDdlDataSourceActionKt.getElementsByDs(e);
    }

    public static final /* synthetic */ boolean access$setUp(Project project, SqlDataSource sqlDs2, ScriptingTaskBuilder task2, Function1 fileConsumer) {
        return DumpToDdlDataSourceActionKt.setUp(project, sqlDs2, task2, (Function1<? super File, Unit>)fileConsumer);
    }

    public static final /* synthetic */ Couple access$computeFileListChanges(Set files2, Set allFiles) {
        return DumpToDdlDataSourceActionKt.computeFileListChanges(files2, allFiles);
    }

    public static final /* synthetic */ void access$suggestAddingPaths(Project project, SqlDataSource sqlDs2, List extra) {
        DumpToDdlDataSourceActionKt.suggestAddingPaths(project, sqlDs2, extra);
    }

    public static final /* synthetic */ void access$suggestDeletingFiles(Project project, SqlDataSource sqlDs2, List extra) {
        DumpToDdlDataSourceActionKt.suggestDeletingFiles(project, sqlDs2, extra);
    }
}

