/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.CoreDatabaseGridDataHookUp;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridService;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.TxIsolationOwner,
DataRequest.DepartmentHolder,
CoreDatabaseGridDataHookUp {
    private final DatabaseMutator myMutator;
    private final DatabaseDepartment myDepartment;
    protected volatile DatabaseSession mySession;
    private DasTable myDatabaseTable;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    public DatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department) {
        if (project == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, session2.getMessageBus());
        this.mySession = session2;
        this.myDepartment = department;
        this.myMutator = DataGridService.getInstance().createMutator(this.getDataModel(), this.getMutationModel(), this, this.myStorage);
    }

    @Override
    @NotNull
    protected MutationsStorage createMutationStorage() {
        return new MutationsStorage(this.myModel, 500, 10);
    }

    public void setSession(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(3);
        }
        this.mySession = session2;
        this.setDataBus(session2.getMessageBus());
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(4);
        }
        return this == owner || this.getSession().isChildOf(owner);
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DatabaseDepartment databaseDepartment = this.myDepartment;
        if (databaseDepartment == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(5);
        }
        return databaseDepartment;
    }

    @Nullable
    public DatabaseMutator getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        return new DatabaseLoader();
    }

    @Override
    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource2 = this.getDataSource();
        if (!dataSource2.isWritable()) {
            return true;
        }
        ObjectKind kind = this.myDatabaseTable != null ? this.myDatabaseTable.getKind() : null;
        return !DbImplUtilCore.isEditableTable(this.getDbms(), kind);
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @Override
    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(6);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(7);
        }
        this.mySession.setCurrentTx(txMarker);
    }

    @Override
    @Nullable
    public DasTable getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)((Object)this.myDatabaseTable)).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasTable databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(8);
        }
        return databaseSession;
    }

    @Override
    @NotNull
    public DbDataSource getDataSource() {
        LocalDataSource target = (LocalDataSource)this.mySession.getTarget();
        DbDataSource dbDataSource = Objects.requireNonNull(DbImplUtilCore.getDbDataSource(this.getProject(), target));
        if (dbDataSource == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(9);
        }
        return dbDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getDataSource().getDbms();
        if (dbms == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(10);
        }
        return dbms;
    }

    @Override
    @Nullable
    public DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column2) {
        if (column2 == null) {
            return null;
        }
        DasTable dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from(DasUtil.getColumns(dasTable)).filter(DasUtil.byName(column2.name)).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns = this.myModel.getColumns();
        for (DataConsumer.Column column2 : columns) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column2.columnNum));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column2.name)))) continue;
            return null;
        }
        return this.myTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private boolean myLastColumnIsRowId;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                DatabaseLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                DatabaseLoader.$$$reportNull$$$0(1);
            }
            boolean sameQuery = Objects.equals(this.getQueryText(), context.getQuery());
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)context.request), ConsoleDataRequest.class);
            ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = request == null ? null : request.getResultSetSubquery(resultSetIndex);
            SqlTableType sqlTableType = DatabaseGridDataHookUp.this.myTableType = resultSetSubQuery == null ? null : resultSetSubQuery.resultType;
            DatabaseGridDataHookUp.this.myReadOnly = sameQuery ? DatabaseGridDataHookUp.this.myReadOnly : !DbSqlUtil.isResultEditable(context.request, DatabaseGridDataHookUp.this.myTableType, DatabaseGridDataHookUp.this.myDatabaseTable);
            DatabaseGridDataHookUp.this.myMutator.pageReloaded();
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
        }

        @Override
        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                DatabaseLoader.$$$reportNull$$$0(2);
            }
            GridHelper helper = GridHelper.get(DatabaseGridDataHookUp.this.getDbms());
            DasTable dasTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            THashMap nameToDasColumn = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            if (dasTable != null) {
                for (DasColumn dasColumn : DasUtil.getColumns(dasTable)) {
                    nameToDasColumn.put(dasColumn.getName(), dasColumn);
                }
            }
            for (int i2 = 0; i2 < columns.length; ++i2) {
                DataConsumer.Column column2 = columns[i2];
                DasColumn databaseColumn = (DasColumn)nameToDasColumn.get(column2.getName());
                EnumSet<DataConsumer.Column.Attribute> attributes2 = EnumSet.noneOf(DataConsumer.Column.Attribute.class);
                attributes2.addAll(column2.attributes);
                if (databaseColumn != null) {
                    attributes2.addAll(helper.getAttributes(databaseColumn));
                }
                int type = column2.type;
                if (databaseColumn != null && (column2.type == 0 || column2.type == 1111)) {
                    type = this.getJdbcType(databaseColumn);
                } else if (i2 == columns.length - 1 && this.myLastColumnIsRowId) {
                    attributes2.add(DataConsumer.Column.Attribute.ROW_ID);
                }
                if (type == column2.type && attributes2.equals(column2.attributes)) continue;
                columns[i2] = new DataConsumer.Column(column2.columnNum, column2.name, type, column2.typeName, column2.clazz, column2.precision, column2.scale, column2.catalog, column2.schema, column2.table, attributes2);
            }
            return columns;
        }

        @Override
        protected void setQueryText(@Nullable String query) {
            super.setQueryText(query);
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(this.canCountRows(query));
        }

        protected boolean canCountRows(@Nullable String query) {
            return StringUtil.isNotEmpty((String)query) && DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms()).generate(DmlTaskKt.wrapInSelect(query, DatabaseGridDataHookUp.this.getProject()).countAll().build(DbImplUtil.createBuilderForUIExec(DatabaseGridDataHookUp.this.getDbms(), null))) != null;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(3);
            }
            source.phase = GridRequestSource.Phase.COUNT;
            String unlimitedQuery = DatabaseGridDataHookUp.this.getUnlimitedQueryText(false);
            if (unlimitedQuery == null || !this.canCountRows(unlimitedQuery)) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateTotalRowCount(source, unlimitedQuery);
        }

        protected void updateTotalRowCount(@NotNull GridRequestSource source, @NotNull String unlimitedQuery) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(4);
            }
            if (unlimitedQuery == null) {
                DatabaseLoader.$$$reportNull$$$0(5);
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            Dbms dbms = DatabaseGridDataHookUp.this.getDbms();
            Project project = DatabaseGridDataHookUp.this.getProject();
            Version version = system.getVersion();
            String alias = DbImplUtil.findFreeAlias(project, dbms, unlimitedQuery, "t");
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtilCore.getDatabaseDialect(dbms), (DasObject)system);
            WrapInSelectTask task2 = DmlTaskKt.wrapInSelect(unlimitedQuery, project).countAll().version(version).alias(alias).build(builder);
            final WrapInSelectResult result2 = DmlUtilKt.dmlGenerator(dbms).generate(task2);
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                    try {
                        long count = DbImplUtil.getCount((DatabaseConnection)connection2, Objects.requireNonNull(result2).getStatement());
                        DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count, true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2, @Nullable GridRequestSource source) {
            Pair<String, Boolean> pure2;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(6);
            }
            if ((pure2 = this.createQueryTextPure(attributes2, source)) == null) {
                return null;
            }
            this.myLastColumnIsRowId = (Boolean)pure2.getSecond();
            return (String)pure2.getFirst();
        }

        @Nullable
        public Pair<String, Boolean> createQueryTextPure(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2, @Nullable GridRequestSource source) {
            DasTable dbTable;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(7);
            }
            if ((dbTable = DatabaseGridDataHookUp.this.getDatabaseTable()) == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            DmlHelper helper = DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms());
            boolean appendRowId = !this.disableRowId() && helper.hasRowId(dbTable, DatabaseGridDataHookUp.this.getDataSource().getVersion()) && this.needRowId(dbTable);
            DmlTask task2 = source != null && source.phase == GridRequestSource.Phase.LOAD_VALUES_USING_KEYS ? DmlTaskKt.selectUsingKeys(dbTable).model(DatabaseGridDataHookUp.this.getDataModel()).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).insertNewLines(true).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec(dbDialect, (DasObject)dbTable)) : this.selectTask(dbTable).limit(attributes2.limit().orElse(-1)).offset(attributes2.offset().orElse(0)).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec(dbDialect, (DasObject)dbTable));
            DdlBuilder builder = helper.generate(task2);
            boolean lastColumnIsRowId = appendRowId && helper.getHideRowId();
            return Pair.create((Object)builder.getStatement(), (Object)lastColumnIsRowId);
        }

        protected boolean disableRowId() {
            return false;
        }

        @NotNull
        protected SelectTask.Companion.Builder selectTask(@NotNull DasTable dbTable) {
            if (dbTable == null) {
                DatabaseLoader.$$$reportNull$$$0(8);
            }
            SelectTask.Companion.Builder builder = DmlTaskKt.allColumns(dbTable).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).whereClause(this.getWhereClause()).orderBy(this.getOrderBy()).insertNewLines(true);
            if (builder == null) {
                DatabaseLoader.$$$reportNull$$$0(9);
            }
            return builder;
        }

        private int getJdbcType(@NotNull DasColumn column2) {
            BasicTypedElement element2;
            if (column2 == null) {
                DatabaseLoader.$$$reportNull$$$0(10);
            }
            if ((element2 = (BasicTypedElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(column2), BasicTypedElement.class)) == null) {
                return column2.getDataType().jdbcType;
            }
            return DbImplUtil.getModelHelper(element2).getJdbcType(element2);
        }

        private boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(11);
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey(table) == null;
        }

        @Nullable
        protected OrderBy getOrderBy() {
            return null;
        }

        @Nullable
        protected WhereClause getWhereClause() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unlimitedQuery";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbTable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryTextPure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTask";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getJdbcType";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "needRowId";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

