/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbElementSelectInProvider
implements SelectInDatabaseView.Extension {
    @Override
    @Nullable
    public PsiElement findTarget(@NotNull SelectInContext context, boolean strict) {
        VirtualFile file;
        if (context == null) {
            DbElementSelectInProvider.$$$reportNull$$$0(0);
        }
        if (DbImplUtil.isDatabaseVirtualFile(file = context.getVirtualFile())) {
            DbElement dbElement = DbImplUtilCore.findElement(context.getProject(), file);
            Object selector = context.getSelectorInFile();
            DataGridPomTarget.Column column2 = selector instanceof PsiElement ? DataGridPomTarget.unwrapColumn((PsiElement)selector) : null;
            DataConsumer.Column dataColumn = column2 == null ? null : column2.getColumn();
            DbColumn columnElement = dataColumn == null ? null : DasUtil.findChild(dbElement, DbColumn.class, ObjectKind.COLUMN, dataColumn.name);
            return strict ? columnElement : (PsiElement)ObjectUtils.chooseNotNull((Object)columnElement, (Object)dbElement);
        }
        if (DbVFSUtils.isConsoleFile(file)) {
            return strict ? null : DbVFSUtils.getDataSource(context.getProject(), file);
        }
        if (file.getFileType() instanceof DbStorageFileType) {
            DbDataSource existing = DbImplUtil.findDataSourceByFile(context.getProject(), file);
            return existing != null ? existing : PsiUtilCore.NULL_PSI_ELEMENT;
        }
        if (!strict) {
            Project project = context.getProject();
            JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
            return console != null ? DbPsiFacade.getInstance(project).findDataSource(console.getDataSource().getUniqueId()) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DbElementSelectInProvider", "findTarget"));
    }
}

