/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BitStringEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBlobEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultBooleanEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultDateEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultNumericEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultRangeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTextEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.DefaultTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.MongoKeyEditorFactory;
import com.intellij.database.run.ui.grid.editors.MongoObjectEditorFactory;
import com.intellij.database.run.ui.grid.editors.MongoObjectIdEditorFactory;
import com.intellij.database.run.ui.grid.editors.MongoUUIDEditorFactory;
import com.intellij.database.run.ui.grid.editors.PgHstoreEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimeEditorFactory;
import com.intellij.database.run.ui.grid.editors.TimeZonedTimestampEditorFactory;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorFactories
implements GridCellEditorFactoryProvider {
    private static final GridCellEditorFactories INSTANCE = new GridCellEditorFactories();
    private final List<? extends GridCellEditorFactory> myDefaultFactories = Arrays.asList(new DefaultNumericEditorFactory(), new DefaultDateEditorFactory(), new DefaultTimestampEditorFactory(), new DefaultTimeEditorFactory(), new DefaultTextEditorFactory(), new DefaultBlobEditorFactory(), new DefaultBooleanEditorFactory(), new PgHstoreEditorFactory(), new TimeZonedTimestampEditorFactory(), new TimeZonedTimeEditorFactory(), new DefaultRangeEditorFactory(), new BitStringEditorFactory(), new MongoKeyEditorFactory(), new MongoObjectIdEditorFactory(), new MongoUUIDEditorFactory(), new MongoObjectEditorFactory());

    public static GridCellEditorFactories getInstance() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            GridCellEditorFactories.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorFactories.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorFactories.$$$reportNull$$$0(2);
        }
        Object value2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
        return DataGridUtil.getDbms(grid).in(Dbms.DOCUMENT_ORIENTED) && value2 instanceof UnparsedValue && ((UnparsedValue)value2).getDomain() != null ? this.getEditorFactory(grid, Objects.requireNonNull(((UnparsedValue)value2).getDomain())) : this.getEditorFactory(factory -> factory.getSuitability(grid, row, column2), GridCellEditorFactory.class);
    }

    @Override
    @Nullable
    public FactoryWithDomainSupport getEditorFactory(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            GridCellEditorFactories.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            GridCellEditorFactories.$$$reportNull$$$0(4);
        }
        return this.getEditorFactory(factory -> factory.getSuitability(grid, domain), FactoryWithDomainSupport.class);
    }

    private <T> T getEditorFactory(@NotNull Function<T, Integer> suitabilityCheck, Class<T> clazz) {
        if (suitabilityCheck == null) {
            GridCellEditorFactories.$$$reportNull$$$0(5);
        }
        int maxSuitability = 0;
        GridCellEditorFactory bestMatchingFactory = null;
        for (GridCellEditorFactory gridCellEditorFactory : this.myDefaultFactories) {
            GridCellEditorFactory f;
            int suitability;
            if (!clazz.isAssignableFrom(gridCellEditorFactory.getClass()) || (suitability = ((Integer)suitabilityCheck.fun((Object)(f = gridCellEditorFactory))).intValue()) <= maxSuitability) continue;
            maxSuitability = suitability;
            bestMatchingFactory = f;
        }
        return (T)bestMatchingFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "row";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "domain";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "suitabilityCheck";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactories";
        objectArray[2] = "getEditorFactory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

