/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAlterInnerElementBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlocksKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.UntilPattern;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.stubs.SqlColumnDefinitionElementType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "countOfInnerEntries", "", "configureFormattingAttributes", "", "considerBlock", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "Companion", "intellij.database.sql.core.impl"})
public final class SqlAlterInstructionBlock
extends SqlNodeBlock {
    private int countOfInnerEntries;
    @NotNull
    private static final Set<SqlTokenType> instructionStartWords;
    @NotNull
    private static final Set<SqlTokenType> instructionContinueWords;
    @NotNull
    private static final List<FlowPattern> patterns;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.considerBlock(block);
        if (block instanceof SqlAlterInnerElementBlock) {
            int n = this.countOfInnerEntries;
            this.countOfInnerEntries = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        void _true_$iv;
        void $this$choose$iv;
        if (this.countOfInnerEntries == 0) {
            return;
        }
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        boolean toIndent = s2.TABLE_ALTER_ITEM_INDENT;
        boolean toAlign = s2.TABLE_ALTER_ITEM_ALIGN && this.countOfInnerEntries >= 2;
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, s2.TABLE_ALTER_ITEM_WRAP, false, 2, null);
        boolean bl = toIndent;
        Indent indent = SqlFormattingFunKt.getNORMAL_INDENT();
        Indent _false_$iv = SqlFormattingFunKt.getNONE_INDENT();
        boolean $i$f$choose = false;
        Indent i2 = $this$choose$iv != false ? _true_$iv : _false_$iv;
        Alignment a2 = toAlign ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            if (!(b2 instanceof SqlAlterInnerElementBlock)) continue;
            SqlBlock this_$iv = b2;
            boolean $i$f$setAttributes = false;
            this_$iv.setMyWrap(w);
            this_$iv.setMyIndent(i2);
            this_$iv.setMyAlign(a2);
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r1 = block2.getRole();
        BlockRole r2 = block2.getRole();
        if (r1 == BlockRole.PREFIX && r2 == BlockRole.PREFIX) {
            spacing = this.getContext().makeSafeSpaceOrBreak();
        } else if (SqlLeafBlocksKt.isSymbol(block1, '(') || SqlLeafBlocksKt.isSymbol(block2, ')')) {
            spacing = this.getContext().makeNoSpace(true);
        } else if (block2 instanceof SqlComma) {
            spacing = this.getContext().makeNoSpace(this.getContext().getSql().TABLE_ALTER_ITEM_WRAP == 0);
        } else if (r2 == BlockRole.ELEMENT) {
            switch (this.getContext().getSql().TABLE_ALTER_ITEM_WRAP) {
                case 1: {
                    spacing = this.getContext().makeBreak(false);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = this.getContext().makeSafeSpaceOrBreak();
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    static {
        Companion = new Companion(null);
        instructionStartWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_ADD, SqlCommonKeywords.SQL_ALTER, SqlCommonKeywords.SQL_MODIFY, SqlCommonKeywords.SQL_ENABLE, SqlCommonKeywords.SQL_DISABLE, SqlCommonKeywords.SQL_SET, SqlCommonKeywords.SQL_DROP});
        instructionContinueWords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlCommonKeywords.SQL_CONSTRAINT, SqlCommonKeywords.SQL_TRIGGER});
        Object[] objectArray = new FlowPattern[7];
        objectArray[0] = new SimplePattern((byte)0, (byte)5, NodeMatcherKt.matchType(instructionStartWords), NodeMatcherKt.matchType(instructionContinueWords), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        Byte by = 0;
        Byte by2 = 5;
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        objectArray[1] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        Byte by3 = 5;
        Byte by4 = 5;
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
        objectArray[2] = new SingletonPattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        Byte by5 = 5;
        Byte by6 = 5;
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlColumnDefinitionElementType), (String)"SQL_COLUMN_DEFINITION");
        objectArray[3] = new SingletonPattern(by5, by6, NodeMatcherKt.matchType((IElementType)sqlColumnDefinitionElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        Byte by7 = 5;
        Byte by8 = 5;
        IElementType[] iElementTypeArray = new IElementType[2];
        SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
        iElementTypeArray[0] = (IElementType)sqlTokenType3;
        SqlTokenType sqlTokenType4 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_RIGHT_PAREN");
        iElementTypeArray[1] = (IElementType)sqlTokenType4;
        objectArray[4] = new UntilPattern(by7, by8, NodeMatcherKt.matchType(iElementTypeArray), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
        Byte by9 = 5;
        Byte by10 = 5;
        SqlTokenType sqlTokenType5 = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType5, (String)"SQL_COMMA");
        objectArray[5] = new SingletonPattern(by9, by10, NodeMatcherKt.matchType((IElementType)sqlTokenType5), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
        Byte by11 = 5;
        Byte by12 = 6;
        SqlTokenType sqlTokenType6 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType6, (String)"SQL_RIGHT_PAREN");
        objectArray[6] = new SingletonPattern(by11, by12, NodeMatcherKt.matchType((IElementType)sqlTokenType6), BlockRole.SUFFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.7.INSTANCE));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock$Companion;", "", "()V", "instructionContinueWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "getInstructionContinueWords", "()Ljava/util/Set;", "instructionStartWords", "getInstructionStartWords", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        @NotNull
        public final Set<SqlTokenType> getInstructionStartWords() {
            return instructionStartWords;
        }

        @NotNull
        public final Set<SqlTokenType> getInstructionContinueWords() {
            return instructionContinueWords;
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

