/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.FirstAndContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonExpandPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclarationDefinitions;
import com.intellij.sql.formatter.model.SqlDeclarationSectionBlock;
import com.intellij.sql.formatter.model.SqlDefinitionsSubsectionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLanguageClauseBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParametersBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlPrefixClauseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReturnBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.formatter.model.SqlUnsortedClauseBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.stubs.SqlTypedDefinitionElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/formatter/model/SqlRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "Companion", "intellij.database.sql.core.impl"})
public final class SqlRoutineBlock
extends SqlNodeBlock {
    @NotNull
    private static final Set<SqlTokenType> regularCaseFirstKeywords;
    @NotNull
    private static final Set<SqlTokenType> regularCaseNextKeywords;
    @NotNull
    private static final Set<SqlTokenType> shortCaseKeywords;
    @NotNull
    private static final List<FlowPattern> patterns;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE)) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE)) {
            SqlFlowBlock sqlFlowBlock;
            if (SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.BODY) != null) {
                void $this$withSetup$iv;
                SqlRangeBlock sqlRangeBlock = new SqlPostfixClauseBlock();
                SqlBlock parent$iv = this;
                boolean $i$f$withSetup = false;
                TextRange textRange = node.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"outerNode.textRange");
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
                sqlFlowBlock = (SqlFlowBlock)$this$withSetup$iv;
            } else {
                void var3_4;
                SqlNodeBlock $this$withSetup$iv = new SqlPrefixClauseBlock();
                SqlBlock parent$iv = this;
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, node);
                sqlFlowBlock = (SqlFlowBlock)var3_4;
            }
            sqlBlock = sqlFlowBlock;
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block.getRole() == BlockRole.PREFIX ? SqlFormattingFunKt.getNONE_INDENT() : super.defaultChildIndent(block);
    }

    @Override
    protected void configureFormattingAttributes() {
        Wrap mainWrap = SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null);
        Wrap prefixOptionsWrap = null;
        Wrap postfixOptionsWrap = null;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            SqlBlock wrap$iv;
            Indent indent$iv;
            Alignment align$iv;
            SqlBlock this_$iv;
            Indent indent$iv2;
            SqlBlock sqlBlock = b2;
            if (sqlBlock instanceof SqlDeclarationSectionBlock) {
                SqlBlock sqlBlock2 = b2;
                indent$iv2 = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(mainWrap);
                this_$iv.setMyIndent(indent$iv2);
                this_$iv.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlDefinitionsSubsectionBlock) {
                this_$iv = b2;
                indent$iv2 = SqlFormattingFunKt.getNORMAL_INDENT();
                align$iv = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(mainWrap);
                this_$iv.setMyIndent(indent$iv2);
                this_$iv.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlBlockStatementBlock || sqlBlock instanceof SqlQueryBlock) {
                this_$iv = b2;
                indent$iv2 = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(mainWrap);
                this_$iv.setMyIndent(indent$iv2);
                this_$iv.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlReturnBlock) {
                this_$iv = b2;
                indent$iv2 = b2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? mainWrap : null;
                indent$iv = SqlFormattingFunKt.getNORMAL_INDENT();
                Alignment align$iv2 = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap((Wrap)wrap$iv);
                this_$iv.setMyIndent(indent$iv);
                this_$iv.setMyAlign(align$iv2);
                continue;
            }
            if (sqlBlock instanceof SqlKeyword) {
                SqlBlock this_$iv2;
                this_$iv = ((SqlKeyword)b2).getElementType();
                if (Intrinsics.areEqual((Object)this_$iv, (Object)SqlTokens.SQL_CREATE) || Intrinsics.areEqual((Object)this_$iv, (Object)SqlTokens.SQL_ALTER)) {
                    wrap$iv = b2;
                    indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                    Alignment align$iv3 = this_$iv2.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    this_$iv2.setMyWrap(mainWrap);
                    this_$iv2.setMyIndent(indent$iv);
                    this_$iv2.setMyAlign(align$iv3);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)this_$iv, (Object)SqlTokens.SQL_AS)) continue;
                this_$iv2 = b2;
                Indent indent$iv3 = SqlFormattingFunKt.getNONE_INDENT();
                Wrap wrap$iv2 = this_$iv2.getMyWrap();
                Alignment align$iv4 = this_$iv2.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv2.setMyWrap(wrap$iv2);
                this_$iv2.setMyIndent(indent$iv3);
                this_$iv2.setMyAlign(align$iv4);
                continue;
            }
            if (sqlBlock instanceof SqlPrefixClauseBlock) {
                if (prefixOptionsWrap == null) {
                    this_$iv = b2;
                    indent$iv2 = this_$iv.getMyIndent();
                    align$iv = this_$iv.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    this_$iv.setMyWrap(mainWrap);
                    this_$iv.setMyIndent(indent$iv2);
                    this_$iv.setMyAlign(align$iv);
                    prefixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                    continue;
                }
                this_$iv = b2;
                indent$iv2 = this_$iv.getMyIndent();
                align$iv = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(prefixOptionsWrap);
                this_$iv.setMyIndent(indent$iv2);
                this_$iv.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlPostfixClauseBlock) {
                if (postfixOptionsWrap == null) {
                    this_$iv = b2;
                    indent$iv2 = this_$iv.getMyIndent();
                    align$iv = this_$iv.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    this_$iv.setMyWrap(mainWrap);
                    this_$iv.setMyIndent(indent$iv2);
                    this_$iv.setMyAlign(align$iv);
                    postfixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                    continue;
                }
                this_$iv = b2;
                indent$iv2 = this_$iv.getMyIndent();
                align$iv = this_$iv.getMyAlign();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(postfixOptionsWrap);
                this_$iv.setMyIndent(indent$iv2);
                this_$iv.setMyAlign(align$iv);
                continue;
            }
            if (!(sqlBlock instanceof SqlLanguageClauseBlock) && !(sqlBlock instanceof SqlUnsortedClauseBlock) && !(sqlBlock instanceof SqlUnsortedBlock)) continue;
            this_$iv = b2;
            indent$iv2 = this_$iv.getMyIndent();
            align$iv = this_$iv.getMyAlign();
            boolean $i$f$setAttributes = false;
            this_$iv.setMyWrap(mainWrap);
            this_$iv.setMyIndent(indent$iv2);
            this_$iv.setMyAlign(align$iv);
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlBlock sqlBlock = block2;
        if (sqlBlock instanceof SqlParametersBlock) {
            switch (this.getContext().getSql().ROUTINE_ARG_OPENING) {
                case 1: {
                    spacing = this.getContext().makeSpace(this.getContext().getCom().SPACE_BEFORE_METHOD_PARENTHESES || ((SqlParametersBlock)block2).getOpeningBlock() == null, false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null);
                    break;
                }
            }
        } else {
            spacing = sqlBlock instanceof SqlPrefixClauseBlock ? this.getContext().makeAutoSpacing(true) : (sqlBlock instanceof SqlPostfixClauseBlock ? this.getContext().makeAutoSpacing(true) : super.decideSpacing(block1, block2));
        }
        return spacing;
    }

    static {
        Companion = new Companion(null);
        regularCaseFirstKeywords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlTokens.SQL_CREATE, SqlTokens.SQL_ALTER});
        regularCaseNextKeywords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlTokens.SQL_OR, SqlTokens.SQL_REPLACE, SqlTokens.SQL_ALTER, SqlTokens.SQL_PROCEDURE, SqlTokens.SQL_FUNCTION});
        shortCaseKeywords = SetsKt.setOf((Object[])new SqlTokenType[]{SqlTokens.SQL_PROCEDURE, SqlTokens.SQL_FUNCTION});
        Object[] objectArray = new FlowPattern[9];
        objectArray[0] = new SimplePattern((byte)0, (byte)1, NodeMatcherKt.matchType(regularCaseFirstKeywords), NodeMatcherKt.matchType(regularCaseNextKeywords), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        objectArray[1] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchType(shortCaseKeywords), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARAMETER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARAMETER_LIST");
        objectArray[2] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        SqlTypedDefinitionElementType sqlTypedDefinitionElementType = SqlCompositeElementTypes.SQL_RETURNS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTypedDefinitionElementType), (String)"SQL_RETURNS_CLAUSE");
        objectArray[3] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlTypedDefinitionElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        Object[] objectArray2 = new NodeMatcher[2];
        SqlTokenType sqlTokenType = SqlTokens.SQL_RETURN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_RETURN");
        objectArray2[0] = NodeMatcherKt.matchType((IElementType)sqlTokenType);
        SqlTokenType sqlTokenType2 = SqlTokens.SQL_SELF;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_SELF");
        objectArray2[1] = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
        objectArray[4] = new RowPattern(null, null, CollectionsKt.listOf((Object[])objectArray2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_LANGUAGE_CLAUSE");
        objectArray[5] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_DECLARE_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_DECLARE_STATEMENT");
        objectArray[6] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.7.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlTokens.SQL_DECLARE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_DECLARE");
        objectArray[7] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])new IElementType[]{(IElementType)SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION, (IElementType)SqlCommonTokens.SQL_SEMICOLON}), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.8.INSTANCE)));
        SqlLazyElementType sqlLazyElementType = SqlCompositeElementTypes.SQL_BLOCK_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlLazyElementType, (String)"SQL_BLOCK_STATEMENT");
        objectArray[8] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlLazyElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.9.INSTANCE));
        patterns = CollectionsKt.mutableListOf((Object[])objectArray);
        for (IElementType dt : SqlDeclarationDefinitions.INSTANCE.getDEFINITION_TYPES$intellij_database_sql_core_impl()) {
            FirstAndContinuePattern p2 = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType(dt), new ElementTypeSetContinuePattern(SqlDeclarationDefinitions.INSTANCE.getDEFINITION_AND_DELIMITER_TYPES$intellij_database_sql_core_impl(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.p.1.INSTANCE)));
            Collection collection = patterns;
            boolean bl = false;
            collection.add(p2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/model/SqlRoutineBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "regularCaseFirstKeywords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "getRegularCaseFirstKeywords", "()Ljava/util/Set;", "regularCaseNextKeywords", "getRegularCaseNextKeywords", "shortCaseKeywords", "getShortCaseKeywords", "intellij.database.sql.core.impl"})
    public static final class Companion {
        @NotNull
        public final Set<SqlTokenType> getRegularCaseFirstKeywords() {
            return regularCaseFirstKeywords;
        }

        @NotNull
        public final Set<SqlTokenType> getRegularCaseNextKeywords() {
            return regularCaseNextKeywords;
        }

        @NotNull
        public final Set<SqlTokenType> getShortCaseKeywords() {
            return shortCaseKeywords;
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

