/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.CsBundle;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.psi.impl.CoffeeScriptClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    public CoffeeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    public void visitJSParameter(JSParameter node) {
        JSFunction function;
        super.visitJSParameter(node);
        if (node.getText().startsWith("@") && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunctionExpression.class)) != null && CoffeeScriptUtil.canHoldImplicitProperties(function)) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(node.getLastChild()).textAttributes(CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE).create();
        }
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        if (node == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(2);
        }
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (node.getParent() instanceof CoffeeScriptClassImpl) {
            return;
        }
        super.visitJSReferenceExpression(node);
    }

    public void visitElement(@NotNull PsiElement element) {
        PsiElement lastQualifierElement;
        JSExpression qualifier;
        PsiElement elementBefore;
        PsiElement parent;
        if (element == null) {
            CoffeeScriptAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (PsiUtilCore.getElementType((PsiElement)element) == CoffeeScriptTokenTypes.DOT && (parent = element.getParent()) instanceof JSReferenceExpression && (elementBefore = element.getPrevSibling()) instanceof PsiWhiteSpace && elementBefore.getText().contains("\n") && (qualifier = ((JSReferenceExpression)parent).getQualifier()) != null && PsiUtilCore.getElementType((PsiElement)(lastQualifierElement = qualifier.getLastChild())) == CoffeeScriptTokenTypes.EXIST) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, CsBundle.message("annotation.message.unexpected", new Object[0])).create();
        }
        super.visitElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSReturnStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CoffeeScriptFunctionSignatureChecker
    extends JSFunctionSignatureChecker {
        public CoffeeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
            super(typeChecker);
        }

        protected void registerProblem(JSCallExpression callExpression, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
            if (message == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
            }
            PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
            this.myTypeChecker.registerProblem(place, message, null, fixes);
        }

        public void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
            JSFunction constructor;
            if (node == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
            }
            if (target == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(2);
            }
            if ((constructor = target.getConstructor()) != null) {
                int mandatoryParameters = constructor.getParameterVariables().length;
                for (JSParameter parameter : constructor.getParameterVariables()) {
                    if (!parameter.isOptional()) continue;
                    --mandatoryParameters;
                }
                this.reportProblemIfNotExpectedCountOfParameters(node, mandatoryParameters, constructor.getParameters().length);
            }
        }

        public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int minCount, int maxCount) {
            JSExpression[] arguments = node.getArguments();
            if (arguments.length < minCount || arguments.length > maxCount) {
                if (minCount == maxCount) {
                    this.registerProblem(node, JavaScriptBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{minCount}), new LocalQuickFix[0]);
                } else {
                    this.registerProblem(node, CsBundle.message("inspection.invalid.number.of.parameters.range", minCount, maxCount), new LocalQuickFix[0]);
                }
            }
        }

        protected void checkCallParameters(@NotNull JSCallExpression call, @Nullable PsiElement element, LocalQuickFix @NotNull [] quickFixes) {
            JSArgumentList argumentList;
            if (call == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(3);
            }
            if (quickFixes == null) {
                CoffeeScriptFunctionSignatureChecker.$$$reportNull$$$0(4);
            }
            if (element instanceof JSFunction) {
                for (JSParameter parameter : ((JSFunction)element).getParameterVariables()) {
                    if (parameter.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) == null) continue;
                    return;
                }
            }
            if ((argumentList = call.getArgumentList()) != null && argumentList.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) != null) {
                return;
            }
            super.checkCallParameters(call, element, quickFixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFixes";
                    break;
                }
            }
            objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConstructorCall";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCallParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

