/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.bsh;

import java.io.Serializable;
import org.gradle.internal.impldep.bsh.BshMethod;
import org.gradle.internal.impldep.bsh.CallStack;
import org.gradle.internal.impldep.bsh.Capabilities;
import org.gradle.internal.impldep.bsh.EvalError;
import org.gradle.internal.impldep.bsh.Interpreter;
import org.gradle.internal.impldep.bsh.InterpreterError;
import org.gradle.internal.impldep.bsh.NameSpace;
import org.gradle.internal.impldep.bsh.Primitive;
import org.gradle.internal.impldep.bsh.Reflect;
import org.gradle.internal.impldep.bsh.SimpleNode;
import org.gradle.internal.impldep.bsh.StringUtil;
import org.gradle.internal.impldep.bsh.Types;
import org.gradle.internal.impldep.bsh.UtilEvalError;

public class This
implements Serializable,
Runnable {
    NameSpace namespace;
    transient Interpreter declaringInterpreter;

    static This getThis(NameSpace namespace, Interpreter declaringInterpreter) {
        try {
            Class<?> c;
            if (Capabilities.canGenerateInterfaces()) {
                c = Class.forName("org/gradle/internal/impldep/bsh.XThis");
            } else if (Capabilities.haveSwing()) {
                c = Class.forName("org/gradle/internal/impldep/bsh.JThis");
            } else {
                return new This(namespace, declaringInterpreter);
            }
            return (This)Reflect.constructObject(c, new Object[]{namespace, declaringInterpreter});
        }
        catch (Exception e) {
            throw new InterpreterError("internal error 1 in This: " + e);
        }
    }

    public Object getInterface(Class clas) throws UtilEvalError {
        if (clas.isInstance(this)) {
            return this;
        }
        throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + clas);
    }

    public Object getInterface(Class[] ca) throws UtilEvalError {
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i].isInstance(this)) continue;
            throw new UtilEvalError("Dynamic proxy mechanism not available. Cannot construct interface type: " + ca[i]);
        }
        return this;
    }

    protected This(NameSpace namespace, Interpreter declaringInterpreter) {
        this.namespace = namespace;
        this.declaringInterpreter = declaringInterpreter;
    }

    public NameSpace getNameSpace() {
        return this.namespace;
    }

    public String toString() {
        return "'this' reference to Bsh object: " + this.namespace;
    }

    public void run() {
        try {
            this.invokeMethod("run", new Object[0]);
        }
        catch (EvalError e) {
            this.declaringInterpreter.error("Exception in runnable:" + e);
        }
    }

    public Object invokeMethod(String name, Object[] args) throws EvalError {
        return this.invokeMethod(name, args, null, null, null, false);
    }

    public Object invokeMethod(String methodName, Object[] args, Interpreter interpreter, CallStack callstack, SimpleNode callerInfo, boolean declaredOnly) throws EvalError {
        if (args == null) {
            args = new Object[]{};
        } else {
            Object[] oa = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                oa[i] = args[i] == null ? Primitive.NULL : args[i];
            }
            args = oa;
        }
        if (interpreter == null) {
            interpreter = this.declaringInterpreter;
        }
        if (callstack == null) {
            callstack = new CallStack(this.namespace);
        }
        if (callerInfo == null) {
            callerInfo = SimpleNode.JAVACODE;
        }
        Class[] types = Types.getTypes(args);
        BshMethod bshMethod = null;
        try {
            bshMethod = this.namespace.getMethod(methodName, types, declaredOnly);
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(args, interpreter, callstack, callerInfo);
        }
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (methodName.equals("equals")) {
            Object obj = args[0];
            return this == obj ? Boolean.TRUE : Boolean.FALSE;
        }
        try {
            bshMethod = this.namespace.getMethod("invoke", new Class[]{null, null});
        }
        catch (UtilEvalError utilEvalError) {
            // empty catch block
        }
        if (bshMethod != null) {
            return bshMethod.invoke(new Object[]{methodName, args}, interpreter, callstack, callerInfo);
        }
        throw new EvalError("Method " + StringUtil.methodString(methodName, types) + " not found in bsh scripted object: " + this.namespace.getName(), callerInfo, callstack);
    }

    public static void bind(This ths, NameSpace namespace, Interpreter declaringInterpreter) {
        ths.namespace.setParent(namespace);
        ths.declaringInterpreter = declaringInterpreter;
    }

    static boolean isExposedThisMethod(String name) {
        return name.equals("getClass") || name.equals("invokeMethod") || name.equals("getInterface") || name.equals("wait") || name.equals("notify") || name.equals("notifyAll");
    }
}

