/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;

public class DefaultProjectDependencyConstraint
implements DependencyConstraintInternal {
    private final ProjectDependency projectDependency;
    private String reason;
    private boolean force;

    public DefaultProjectDependencyConstraint(ProjectDependency projectDependency) {
        this.projectDependency = projectDependency;
    }

    public ProjectDependency getProjectDependency() {
        return this.projectDependency;
    }

    @Override
    public void version(Action<? super MutableVersionConstraint> configureAction) {
        throw new UnsupportedOperationException("Cannot change version constraint on a project dependency");
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public void because(@Nullable String reason) {
        this.reason = reason;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.projectDependency.getAttributes();
    }

    @Override
    public DependencyConstraint attributes(Action<? super AttributeContainer> configureAction) {
        this.projectDependency.attributes((Action)configureAction);
        return this;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return new DefaultImmutableVersionConstraint("", this.projectDependency.getVersion(), "", Collections.emptyList(), "");
    }

    @Override
    public String getGroup() {
        return this.projectDependency.getGroup();
    }

    @Override
    public String getName() {
        return this.projectDependency.getName();
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.projectDependency.getVersion();
    }

    @Override
    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return identifier.getModule().equals(this.getModule()) && identifier.getVersion().equals(this.projectDependency.getVersion());
    }

    @Override
    public ModuleIdentifier getModule() {
        String group = this.projectDependency.getGroup();
        return DefaultModuleIdentifier.newId(group != null ? group : "", this.projectDependency.getName());
    }

    @Override
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }
}

