/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshotContext;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class IgnoringResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final ResourceFilter resourceFilter;

    public IgnoringResourceHasher(ResourceHasher delegate, ResourceFilter resourceFilter) {
        this.delegate = delegate;
        this.resourceFilter = resourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
        this.resourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshotContext snapshotContext) {
        return this.resourceFilter.shouldBeIgnored(snapshotContext.getRelativePathSegments()) ? null : this.delegate.hash(snapshotContext);
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.resourceFilter.shouldBeIgnored(zipEntryContext.getRelativePathSegments()) ? null : this.delegate.hash(zipEntryContext);
    }
}

