/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.swift;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.org.yaml.snakeyaml.Yaml;
import org.gradle.internal.impldep.org.yaml.snakeyaml.constructor.BaseConstructor;
import org.gradle.internal.impldep.org.yaml.snakeyaml.constructor.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwiftDepsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwiftDepsHandler.class);
    static final List RESET_TIMESTAMP = Arrays.asList(0L, 0L);

    SwiftDepsHandler() {
    }

    SwiftDeps parse(File moduleSwiftDeps) throws FileNotFoundException {
        return IoActions.withResource(new FileInputStream(moduleSwiftDeps), new Transformer<SwiftDeps, FileInputStream>(){

            @Override
            public SwiftDeps transform(FileInputStream fileInputStream) {
                Yaml yaml = new Yaml((BaseConstructor)new Constructor(SwiftDeps.class));
                return (SwiftDeps)yaml.loadAs((InputStream)fileInputStream, SwiftDeps.class);
            }
        });
    }

    private void adjustTimestamps(SwiftDeps swiftDeps, Collection<File> changedSources) {
        for (File changedSource : changedSources) {
            if (!swiftDeps.inputs.containsKey(changedSource.getAbsolutePath())) continue;
            swiftDeps.inputs.put(changedSource.getAbsolutePath(), RESET_TIMESTAMP);
        }
    }

    private void write(File moduleSwiftDeps, final SwiftDeps swiftDeps) {
        IoActions.writeTextFile(moduleSwiftDeps, (Action<? super BufferedWriter>)new Action<BufferedWriter>(){

            @Override
            public void execute(BufferedWriter bufferedWriter) {
                PrintWriter pw = new PrintWriter(bufferedWriter);
                pw.println("version: \"" + swiftDeps.version + "\"");
                pw.println("options: \"" + swiftDeps.options + "\"");
                pw.println("build_time: [" + swiftDeps.build_time.get(0) + ", " + swiftDeps.build_time.get(1) + "]");
                pw.println("inputs:");
                swiftDeps.inputs.forEach((file, timestamp) -> pw.println("  \"" + file + "\": [" + timestamp.get(0) + ", " + timestamp.get(1) + "]"));
            }
        });
    }

    boolean adjustTimestampsFor(File moduleSwiftDeps, Collection<File> changedSources) {
        if (moduleSwiftDeps.exists() && !changedSources.isEmpty()) {
            try {
                SwiftDeps swiftDeps = this.parse(moduleSwiftDeps);
                this.adjustTimestamps(swiftDeps, changedSources);
                this.write(moduleSwiftDeps, swiftDeps);
            }
            catch (Exception e) {
                LOGGER.debug("could not update module.swiftdeps", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static class SwiftDeps {
        private String version;
        private String options;
        private List<Long> build_time;
        private Map<String, List> inputs;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getOptions() {
            return this.options;
        }

        public void setOptions(String options) {
            this.options = options;
        }

        public List<Long> getBuild_time() {
            return this.build_time;
        }

        public void setBuild_time(List<Long> build_time) {
            this.build_time = build_time;
        }

        public Map<String, List> getInputs() {
            return this.inputs;
        }

        public void setInputs(Map<String, List> inputs) {
            this.inputs = inputs;
        }

        public String toString() {
            return "SwiftDeps{version='" + this.version + '\'' + ", options='" + this.options + '\'' + ", build_time=" + this.build_time + ", inputs=" + this.inputs + '}';
        }
    }
}

