/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.gradle.internal.Cast;

public class MBeanAttributeProvider {
    public static <T> T getMbeanAttribute(String mbean, String attribute, Class<T> type) {
        JMException rootCause;
        try {
            ObjectName objectName = new ObjectName(mbean);
            return Cast.cast(type, ManagementFactory.getPlatformMBeanServer().getAttribute(objectName, attribute));
        }
        catch (InstanceNotFoundException e) {
            rootCause = e;
        }
        catch (ReflectionException e) {
            rootCause = e;
        }
        catch (MalformedObjectNameException e) {
            rootCause = e;
        }
        catch (MBeanException e) {
            rootCause = e;
        }
        catch (AttributeNotFoundException e) {
            rootCause = e;
        }
        throw new UnsupportedOperationException("(" + mbean + ")." + attribute + " is unsupported on this JVM.", rootCause);
    }
}

