/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditorNotifications;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.fix.TsLintErrorFixAction;
import com.intellij.lang.javascript.linter.tslint.fix.TsLintFileFixAction;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintInspection;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintSuppressionUtil;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLinterInput;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.linter.tslint.service.TslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.tslint.ui.TsLintConfigurable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintExternalAnnotator
extends JSLinterWithInspectionExternalAnnotator<TsLintState, TsLinterInput> {
    private static final TsLintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new TsLintExternalAnnotator(false);

    @NotNull
    public static TsLintExternalAnnotator getInstanceForBatchInspection() {
        TsLintExternalAnnotator tsLintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (tsLintExternalAnnotator == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return tsLintExternalAnnotator;
    }

    public TsLintExternalAnnotator() {
        this(true);
    }

    public TsLintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @NotNull
    protected JSLinterConfigurable<TsLintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(1);
        }
        return new TsLintConfigurable(project, true);
    }

    protected Class<? extends JSLinterConfiguration<TsLintState>> getConfigurationClass() {
        return TsLintConfiguration.class;
    }

    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return TsLintInspection.class;
    }

    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        TsLintConfiguration configuration = TsLintConfiguration.getInstance(file.getProject());
        if (((TsLintState)configuration.getExtendedState().getState()).isAllowJs() && JSUtils.isJavaScriptFile((PsiFile)file)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
        return holder != null && holder.isTypeScript;
    }

    @Nullable
    protected TsLinterInput createInfo(@NotNull PsiFile psiFile, TsLintState state, EditorColorsScheme colorsScheme) {
        VirtualFile config;
        boolean skipProcessing;
        if (psiFile == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(3);
        }
        boolean bl = skipProcessing = (config = TslintUtil.getConfig(state, psiFile.getProject(), psiFile.getVirtualFile())) != null && this.saveConfigFileAndReturnSkipProcessing(psiFile.getProject(), config);
        if (skipProcessing) {
            return null;
        }
        return new TsLinterInput(psiFile, state, colorsScheme, config);
    }

    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull TsLinterInput collectedInfo) {
        if (collectedInfo == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(4);
        }
        return (JSLinterAnnotationResult)TslintLanguageServiceManager.getInstance(collectedInfo.getProject()).useService(collectedInfo.getVirtualFile(), ((TsLintState)collectedInfo.getState()).getNodePackageRef(), service -> TsLintExternalAnnotator.annotateWithService(collectedInfo, service));
    }

    @Nullable
    private static JSLinterAnnotationResult annotateWithService(@NotNull TsLinterInput collectedInfo, @Nullable TsLintLanguageService service) {
        List result;
        if (collectedInfo == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(5);
        }
        VirtualFile config = collectedInfo.getConfig();
        Project project = collectedInfo.getProject();
        TsLintState linterState = (TsLintState)collectedInfo.getState();
        if (service == null) {
            return null;
        }
        JSLinterFileLevelAnnotation interpreterAndPackageError = JSLinterUtil.validateInterpreterAndPackage((Project)project, (NodeJsInterpreter)linterState.getInterpreterRef().resolve(project), (NodePackage)service.getNodePackage(), (String)"tslint", (VirtualFile)collectedInfo.getVirtualFile());
        if (interpreterAndPackageError != null) {
            return JSLinterAnnotationResult.create((JSLinterInput)collectedInfo, (JSLinterFileLevelAnnotation)interpreterAndPackageError, (VirtualFile)config);
        }
        CompletableFuture<List<TsLinterError>> future = service.highlight(collectedInfo.getVirtualFile(), config, collectedInfo.getFileContent(), linterState);
        try {
            result = (List)JSLanguageServiceUtil.awaitLanguageService(future, (LinterLanguageServiceClient)service, (VirtualFile)collectedInfo.getVirtualFile());
        }
        catch (ExecutionException e) {
            return TsLintExternalAnnotator.createGlobalErrorMessage(collectedInfo, config, e.getMessage());
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        Optional<TsLinterError> globalError = result.stream().filter(error -> error.isGlobal()).findFirst();
        if (globalError.isPresent() && !StringUtil.isEmptyOrSpaces((String)globalError.get().getDescription())) {
            return TsLintExternalAnnotator.createGlobalErrorMessage(collectedInfo, config, globalError.get().getDescription());
        }
        List<TsLinterError> filtered = TsLintExternalAnnotator.filterResultByFile(collectedInfo.getVirtualFile(), result);
        return JSLinterAnnotationResult.createLinterResult((JSLinterInput)collectedInfo, filtered, (VirtualFile)config);
    }

    private static List<TsLinterError> filterResultByFile(@NotNull VirtualFile virtualFile, @NotNull List<TsLinterError> annotationErrors) {
        if (virtualFile == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (annotationErrors == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(7);
        }
        String filePath = virtualFile.getPath();
        String fileName = virtualFile.getName();
        return ContainerUtil.filter(annotationErrors, error -> {
            String path = error.getAbsoluteFilePath();
            return path == null || path.endsWith(fileName) && FileUtil.pathsEqual((String)filePath, (String)path);
        });
    }

    @NotNull
    private static JSLinterAnnotationResult createGlobalErrorMessage(@NotNull TsLinterInput collectedInfo, @Nullable VirtualFile config, @NotNull @InspectionMessage String error) {
        if (collectedInfo == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(8);
        }
        if (error == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(9);
        }
        ProcessOutput output = new ProcessOutput();
        output.appendStderr(error);
        IntentionAction detailsAction = JSLinterUtil.createDetailsAction((Project)collectedInfo.getProject(), (VirtualFile)collectedInfo.getVirtualFile(), null, (ProcessOutput)output, null);
        JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(error, detailsAction);
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create((JSLinterInput)collectedInfo, (JSLinterFileLevelAnnotation)annotation, (VirtualFile)config);
        if (jSLinterAnnotationResult == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(10);
        }
        return jSLinterAnnotationResult;
    }

    protected void cleanNotification(@NotNull TsLinterInput collectedInfo) {
        if (collectedInfo == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(11);
        }
        JSLinterEditorNotifications.clearNotification((Project)collectedInfo.getProject(), this.getInspectionClass(), (VirtualFile)collectedInfo.getVirtualFile());
    }

    public boolean saveConfigFileAndReturnSkipProcessing(@NotNull Project project, @NotNull VirtualFile config) {
        if (project == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(12);
        }
        if (config == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(13);
        }
        return (Boolean)ReadAction.compute(() -> {
            FileDocumentManager manager = FileDocumentManager.getInstance();
            Document document = manager.getCachedDocument(config);
            if (document != null) {
                boolean unsaved = manager.isDocumentUnsaved(document);
                if (unsaved) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Document newDocument = manager.getCachedDocument(config);
                        if (newDocument != null) {
                            FileDocumentManager.getInstance().saveDocument(newDocument);
                        }
                        DaemonCodeAnalyzer.getInstance((Project)project).restart();
                    }, project.getDisposed());
                }
                return unsaved;
            }
            return false;
        });
    }

    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            TsLintExternalAnnotator.$$$reportNull$$$0(15);
        }
        if (annotationResult == null) {
            return;
        }
        TsLintConfigurable configurable = new TsLintConfigurable(file.getProject(), true);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        long documentModificationStamp = document != null ? document.getModificationStamp() : -1L;
        IntentionAction fixAllFileIntention = new TsLintFileFixAction().asIntentionAction();
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setShowEditSettings(false).setEditConfig(false);
        fixes.setErrorToIntentionConverter(errorBase -> {
            if (!(errorBase instanceof TsLinterError)) {
                return ContainerUtil.emptyList();
            }
            TsLinterError tslintError = (TsLinterError)((Object)errorBase);
            ArrayList<TsLintErrorFixAction> result = new ArrayList<TsLintErrorFixAction>();
            if (tslintError.hasFix()) {
                if (document != null && this.isOnTheFly()) {
                    result.add(new TsLintErrorFixAction(file, tslintError, documentModificationStamp));
                }
                result.add((TsLintErrorFixAction)fixAllFileIntention);
            } else if (!holder.isBatchMode()) {
                ContainerUtil.addIfNotNull(result, (Object)TsLintSuppressionUtil.INSTANCE.getSuppressForLineAction(tslintError, documentModificationStamp));
            }
            return result;
        }).setProblemGroup(error -> {
            if (this.isOnTheFly() && error instanceof TsLinterError) {
                return new JSAnnotatorProblemGroup(TsLintSuppressionUtil.INSTANCE.getSuppressionsForError((TsLinterError)((Object)error), documentModificationStamp), null);
            }
            return null;
        });
        new JSLinterAnnotationsBuilder(file, annotationResult, holder, (UntypedJSLinterConfigurable)configurable, TsLintBundle.message("tslint.framework.title", new Object[0]) + ": ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationErrors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/highlight/TsLintExternalAnnotator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterResultByFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGlobalErrorMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cleanNotification";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveConfigFileAndReturnSkipProcessing";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

