/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ClangExternalResolver
implements OCExternalResolver {
    private static final Logger LOG = Logger.getInstance((String)ExternalResolveUtils.class.getName());
    private static final Key<CachedValue<Map<Integer, List<OCExternalResolver.Resolved>>>> TEST_CLANG_RESOLVE_CACHE = Key.create((String)"TEST_CLANG_RESOLVE_CACHE");
    private static final long CLANG_RESPONSE_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : Long.MAX_VALUE;

    @NotNull
    public List<OCExternalResolver.Resolved> resolve(@NotNull PsiFile file, int offset) {
        List<OCExternalResolver.Resolved> result3;
        ClangLocalWorkspace workspace;
        CachedValueProvider provider;
        CachedValuesManager manager;
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(0);
        }
        if (!ClangUtils.isClangdOn((Project)file.getProject())) {
            List<OCExternalResolver.Resolved> list = Collections.emptyList();
            if (list == null) {
                ClangExternalResolver.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!ClangUtils.isNavigationViaClangd((Project)file.getProject())) {
            List<OCExternalResolver.Resolved> list = Collections.emptyList();
            if (list == null) {
                ClangExternalResolver.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Map cache = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (cache = (Map)(manager = CachedValuesManager.getManager((Project)project)).getCachedValue((UserDataHolder)file, TEST_CLANG_RESOLVE_CACHE, provider = () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).containsKey(offset)) {
            List list = (List)cache.get(offset);
            if (list == null) {
                ClangExternalResolver.$$$reportNull$$$0(3);
            }
            return list;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
        SimpleOpenRequestId openRequestId = null;
        if (ClangdBridge.CLANG_CAN_OPEN_FILE.get((UserDataHolder)project) != null && (workspace = service.getLocalWorkspace()) != null && !((Boolean)workspace.apply(virtualFile.getUrl(), wf -> wf.isOpened())).booleanValue()) {
            openRequestId = new SimpleOpenRequestId(ExternalResolveUtils.class, "Opened [" + virtualFile.getPath() + "]");
            service.notifyDocumentOpened(virtualFile, (OpenRequestId)openRequestId);
        }
        Ref clangSymsRef = Ref.create();
        try {
            service.gotoDefinition(virtualFile, offset, result2 -> clangSymsRef.set((Object)((List)result2.waitForResult(CLANG_RESPONSE_TIMEOUT_MS))));
        }
        catch (TimeoutException ex) {
            LOG.warn(ClangExternalResolver.toMessageWithOffset(ex, file, offset));
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException((Logger)LOG, (String)ClangExternalResolver.toMessageWithOffset(ex, file, offset), (ExecutionException)ex);
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)ex);
            }
            LOG.error(ClangExternalResolver.toMessageWithOffset(ex, file, offset), (Throwable)ex);
        }
        List clangSyms = (List)clangSymsRef.get();
        if (openRequestId != null && ClangdBridge.CLANG_DONT_CLOSE_FILE.get((UserDataHolder)project) == null) {
            service.notifyDocumentClosed(virtualFile, (OpenRequestId)openRequestId);
        }
        List<Object> list = result3 = !ContainerUtil.isEmpty((Collection)clangSyms) ? clangSyms.stream().filter(sym -> !sym.isMacro).map(sym -> new OCExternalResolver.Resolved(sym.location.uri, sym.name, sym.location.position.getLine(), sym.location.position.getColumn())).collect(Collectors.toList()) : Collections.emptyList();
        if (cache != null) {
            cache.put(offset, result3);
        }
        List<OCExternalResolver.Resolved> list2 = result3;
        if (list2 == null) {
            ClangExternalResolver.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        String string;
        if (original == null) {
            ClangExternalResolver.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ClangExternalResolver.$$$reportNull$$$0(6);
        }
        try {
            string = "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ClangExternalResolver.$$$reportNull$$$0(8);
            }
            return string2;
        }
        if (string == null) {
            ClangExternalResolver.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangExternalResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangExternalResolver";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

